/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class B5Wmod
extends RegularPumpingLemma {
    @Override
    public String getTitle() {
        return "b^5w: w element_of {ab}* : (2na(w) + 5nb(w)) % 3 = 0";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>b<sup>5</sup>w</i> : <i>w</i> " + ELEMENT_OF + " " + AB_STAR + ", (2<i>n<sub>a</sub></i> (<i>w</i>) + " + " 5<i>n<sub>b</sub></i> (<i>w</i>)) mod 3 = 0";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = true;
        this.explanation = "Because this is a regular language, a valid decomposition exists.  If <i>m</i> " + GREATER_OR_EQ + " 8, " + "as long as |<i>y</i>| % 3 = 0 and none of the first 5 \"b\"s are in <i>y</i>, the decomposition is " + "successful.  Pumping any possible combination of 3 characters yields a string divisible by 3.";
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    @Override
    protected void chooseW() {
        this.w = "bbbbb";
        for (int i = 5; i < this.m || (i - 5) % 3 != 0; ++i) {
            this.w = LemmaMath.flipCoin() == 2 ? this.w + 'a' : this.w + 'b';
        }
    }

    @Override
    public void chooseDecomposition() {
        this.setDecomposition(new int[]{5, 3});
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{8, 20};
    }

    @Override
    public boolean isInLang(String string) {
        int n;
        char[] cArray = new char[]{'a', 'b'};
        if (LemmaMath.otherCharactersFound(string, cArray)) {
            return false;
        }
        if (!string.startsWith("bbbbb")) {
            return false;
        }
        String string2 = string.substring(5);
        int n2 = LemmaMath.countInstances(string2, 'a');
        return (2 * n2 + 5 * (n = LemmaMath.countInstances(string2, 'b'))) % 3 == 0;
    }
}

