/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class AnBlAk
extends RegularPumpingLemma {
    @Override
    public String getTitle() {
        return "a^n b^l a^k : n > 5, l > 3, k <= l";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>n</sup>b<sup>l</sup>a<sup>k</sup></i> : <i>n</i> " + GREATER_THAN + " 5, <i>l</i> " + GREATER_THAN + " 3, <i>k</i> " + LESS_OR_EQ + " <i>l</i>";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value " + GREATER_OR_EQ + " 4, a possible value for <i>w</i> is \"a<sup>6</sup>" + "b<sup><i>m</i></sup>a<sup><i>m</i></sup>\".  The <i>y</i> value thus would be a combination of \"a\"s " + "and \"b\"s, in that order.  If <i>i</i> = 0, either n " + LESS_OR_EQ + " 5, k > l, or both, giving a " + "string that is not in the language.  Thus, the language is not regular.";
    }

    @Override
    protected void chooseW() {
        this.w = this.getM() <= 3 ? AnBlAk.pumpString("a", 6) + AnBlAk.pumpString("b", 4) + AnBlAk.pumpString("a", 4) : AnBlAk.pumpString("a", 6) + AnBlAk.pumpString("b", this.getM()) + AnBlAk.pumpString("a", this.getM());
    }

    @Override
    public void chooseDecomposition() {
        int n = this.w.indexOf(98);
        if (n > 6) {
            this.setDecomposition(new int[]{0, 1});
        } else {
            this.setDecomposition(new int[]{Math.min(n, this.m - 1), 1});
        }
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 15};
    }

    @Override
    public boolean isInLang(String string) {
        char[] cArray = new char[]{'a', 'b', 'a'};
        if (LemmaMath.isMixture(string, cArray)) {
            return false;
        }
        int n = LemmaMath.countInstances(string, 'b');
        if (n == 0) {
            return false;
        }
        String string2 = string.substring(string.indexOf(98));
        int n2 = string.length() - string2.length();
        int n3 = LemmaMath.countInstances(string2, 'a');
        return n2 > 5 && n > 3 && n3 <= n;
    }
}

