/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class AnBk
extends RegularPumpingLemma {
    @Override
    public String getTitle() {
        return "a^n b^k : n is odd or k is even";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>n</sup>b<sup>k</sup></i> : <i>n</i> is odd or <i>k</i> is even.";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = true;
        this.explanation = "Because this is a regular language, a valid decomposition exists.  If <i>m</i> " + GREATER_OR_EQ + " 3, a <i>y</i> value of \"aa\" or \"bb\" will always pump the string.  At least one of those substrings " + "can be the <i>y</i> value.";
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 10};
    }

    @Override
    public void chooseI() {
        this.i = LemmaMath.flipCoin();
    }

    @Override
    protected void chooseW() {
        this.w = this.m % 2 == 0 ? AnBk.pumpString("a", this.m - 2) + "bb" : "a" + AnBk.pumpString("b", this.m);
    }

    @Override
    public void chooseDecomposition() {
        int n = this.w.indexOf(98);
        if (n == -1 || n >= 2) {
            this.setDecomposition(new int[]{0, 2});
        } else {
            this.setDecomposition(new int[]{n, 2});
        }
    }

    @Override
    public boolean isInLang(String string) {
        char[] cArray = new char[]{'a', 'b'};
        if (LemmaMath.isMixture(string, cArray)) {
            return false;
        }
        int n = LemmaMath.countInstances(string, 'a');
        int n2 = LemmaMath.countInstances(string, 'b');
        return n % 2 == 1 || n2 % 2 == 0;
    }
}

