/*
 * Decompiled with CFR 0.152.
 */
package pumping.reg;

import pumping.LemmaMath;
import pumping.RegularPumpingLemma;

public class ABnAk
extends RegularPumpingLemma {
    @Override
    public String getTitle() {
        return "(ab)^n a^k : n > k, k >= 0";
    }

    @Override
    public String getHTMLTitle() {
        return "(<i>ab</i>)<i><sup>n</sup>a<sup>k</sup></i> : <i>n</i> " + GREATER_THAN + " <i>k</i>, <i>k</i> " + GREATER_OR_EQ + " 0";
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{2, 11};
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"(ab)<sup><i>m</i>+1</sup>a<sup><i>m</i></sup>\".  To be in the language, <i>y</i> must possess \"ab\"s, \"ba\"s, \"a\"s, and/or \"b\"s.  Any multiple or combination thereof yields a string that is not in the language when <i>i</i> = 0, meaning this is not a regular language.";
    }

    @Override
    protected void chooseW() {
        this.w = ABnAk.pumpString("ab", this.m + 1) + ABnAk.pumpString("a", this.m);
    }

    @Override
    public void chooseDecomposition() {
        this.setDecomposition(new int[]{0, 2});
    }

    @Override
    public void chooseI() {
        this.i = 0;
    }

    @Override
    public boolean isInLang(String string) {
        int n;
        char[] cArray = new char[]{'a'};
        String string2 = string;
        while (string2.startsWith("ab")) {
            string2 = string2.substring(2);
        }
        if (string2.equals(new String("ab"))) {
            return true;
        }
        if (LemmaMath.isMixture(string2, cArray)) {
            return false;
        }
        int n2 = LemmaMath.countInstances(string, 'a');
        return n2 < 2 * (n = LemmaMath.countInstances(string, 'b'));
    }
}

