/*
 * Decompiled with CFR 0.152.
 */
package pumping.cf;

import pumping.Case;
import pumping.ContextFreePumpingLemma;
import pumping.LemmaMath;

public class AiBjCk
extends ContextFreePumpingLemma {
    @Override
    public String getTitle() {
        return "a^i b^j c^k : i > j, i > k";
    }

    @Override
    public String getHTMLTitle() {
        return "<i>a<sup>i</sup>b<sup>j</sup>c<sup>k</sup></i> : <i>i</i> " + GREATER_THAN + " <i>j</i>, <i>i</i> " + GREATER_THAN + " <i>k</i>";
    }

    @Override
    public void setDescription() {
        this.partitionIsValid = false;
        this.explanation = "For any <i>m</i> value, a possible value for <i>w</i> is \"a<sup><i>m</i>+1</sup>b<sup><i>m</i></sup>c<sup><i>m</i></sup>\".  The <i>v</i> and <i>y</i> values together thus would have a maximum of two unique letters.  Any possible <i>v</i> or <i>y</i> values would then be problematic if <i>i</i> = 0, <i>i</i> = 2, or perhaps both.  Thus, this language is not context-free.";
    }

    @Override
    protected void chooseW() {
        this.w = AiBjCk.pumpString("a", this.getM() + 1) + AiBjCk.pumpString("b", this.getM()) + AiBjCk.pumpString("c", this.getM());
    }

    @Override
    public void chooseDecomposition() {
        int n = LemmaMath.countInstances(this.w, 'a');
        int n2 = LemmaMath.countInstances(this.w, 'b');
        int n3 = LemmaMath.countInstances(this.w, 'c');
        if (n > n2 + 1 && n > n3 + 1) {
            this.setDecomposition(new int[]{0, 1, 0, 0});
        } else {
            super.chooseDecomposition();
        }
    }

    @Override
    public void chooseI() {
        this.i = this.getV().indexOf("a") == -1 && this.getY().indexOf("a") == -1 ? 2 : 0;
    }

    @Override
    protected void setRange() {
        this.myRange = new int[]{3, 7};
    }

    @Override
    protected void addCases() {
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") == -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{0, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string2.indexOf("a") > -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"a\"s followed by \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AiBjCk.this.m - 1, 1, 0, 2};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") == -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AiBjCk.this.m, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") > -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"a\"s followed by \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AiBjCk.this.m, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") == -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{AiBjCk.this.m + 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") > -1 && string2.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"b\"s followed by \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AiBjCk.this.m - 1, 1, 0, 2};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") == -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AiBjCk.this.m, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") > -1 && string.indexOf("c") > -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"b\"s followed by \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AiBjCk.this.m, 2, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.indexOf("a") == -1 && string.indexOf("b") == -1 && string.indexOf("c") > -1 && string2.indexOf("a") == -1 && string2.indexOf("b") == -1 && string2.indexOf("c") > -1;
            }

            @Override
            public String description() {
                return "v is a string of \"c\"s and y is a string of \"c\"s";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AiBjCk.this.m + 1, 1, 0, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() == 0 && string2.length() > 0;
            }

            @Override
            public String description() {
                return "v is an empty string and y is a non-empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AiBjCk.this.m, 0, 1, 1};
            }
        });
        this.myAllCases.add(new Case(){

            @Override
            public boolean isCase(String string, String string2) {
                return string.length() > 0 && string2.length() == 0;
            }

            @Override
            public String description() {
                return "v is a non-empty string and y is an empty string";
            }

            @Override
            public int[] getPreset() {
                return new int[]{2 * AiBjCk.this.m, 1, 0, 0};
            }
        });
    }

    @Override
    public boolean isInLang(String string) {
        char[] cArray = new char[]{'a', 'b', 'c'};
        if (LemmaMath.isMixture(string, cArray)) {
            return false;
        }
        int n = LemmaMath.countInstances(string, 'a');
        int n2 = LemmaMath.countInstances(string, 'b');
        int n3 = LemmaMath.countInstances(string, 'c');
        return n > n2 && n > n3;
    }
}

