/*
 * Decompiled with CFR 0.152.
 */
package pumping;

import gui.environment.Universe;
import java.io.Serializable;
import pumping.Case;
import pumping.LemmaMath;
import pumping.PumpingLemma;

public abstract class RegularPumpingLemma
extends PumpingLemma
implements Serializable,
Cloneable {
    protected String x;
    protected String y;
    protected String z;

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getZ() {
        return this.z;
    }

    @Override
    public String getDecompositionAsString() {
        int n;
        String[] stringArray = new String[3];
        int n2 = 0;
        for (n = 0; n <= 1; ++n) {
            stringArray[n] = this.w.substring(n2, n2 + this.myDecomposition[n]);
            n2 += this.myDecomposition[n];
        }
        stringArray[2] = this.w.substring(n2);
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].length() != 0) continue;
            stringArray[n] = "" + Universe.curProfile.getEmptyString();
        }
        return "X = " + stringArray[0] + ";   Y = " + stringArray[1] + ";   Z = " + stringArray[2];
    }

    @Override
    public void reset() {
        this.m = -1;
        this.i = -1;
        this.w = "";
        this.x = "";
        this.y = "";
        this.z = "";
    }

    @Override
    public boolean setDecomposition(int[] nArray, int n) {
        this.i = n;
        return this.setDecomposition(nArray);
    }

    @Override
    public boolean setDecomposition(int[] nArray) {
        this.myDecomposition = nArray;
        int n = nArray[0];
        int n2 = nArray[1];
        if (n + n2 > this.m || n2 < 1 || n < 0) {
            return false;
        }
        this.x = this.w.substring(0, n);
        this.y = this.w.substring(n, n + n2);
        this.z = this.w.substring(n + n2);
        return true;
    }

    @Override
    public String createPumpedString() {
        return this.x + RegularPumpingLemma.pumpString(this.y, this.getI()) + this.z;
    }

    @Override
    public int addCase(int[] nArray, int n) {
        int n2;
        if (!this.setDecomposition(nArray)) {
            return -1;
        }
        for (n2 = 0; n2 < this.myDoneCases.size(); ++n2) {
            if (!((Case)this.myDoneCases.get(n2)).isCase(this.y, this.y)) continue;
            return n2;
        }
        for (n2 = 0; n2 < this.myAllCases.size(); ++n2) {
            if (!((Case)this.myAllCases.get(n2)).isCase(this.y, this.y)) continue;
            Case case_ = (Case)this.myAllCases.get(n2);
            case_.setI(n);
            case_.setUserInput(nArray);
            this.myDoneCases.add(case_);
            return this.myAllCases.size();
        }
        System.err.println("BUG FOUND: ContextFreePumpingLemma.addCase(int[])");
        return -1;
    }

    @Override
    protected void addCases() {
    }

    @Override
    public boolean replaceCase(int[] nArray, int n, int n2) {
        Case case_ = (Case)this.myDoneCases.get(n2);
        if (case_.isCase(this.y, this.y)) {
            case_.setI(n);
            case_.setUserInput(nArray);
            return true;
        }
        return false;
    }

    @Override
    public void chooseDecomposition() {
        int n = LemmaMath.fetchRandInt(0, this.getM() - 1);
        this.setDecomposition(new int[]{n, this.getM() - n});
    }
}

