/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.anim.values.AnimatableStringValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAnimatedEnumeration;

public class SVGOMAnimatedEnumeration
extends AbstractSVGAnimatedValue
implements SVGAnimatedEnumeration {
    protected String[] values;
    protected short defaultValue;
    protected boolean valid;
    protected short baseVal;
    protected short animVal;
    protected boolean changing;

    public SVGOMAnimatedEnumeration(AbstractElement elt, String ns, String ln, String[] val, short def) {
        super(elt, ns, ln);
        this.values = val;
        this.defaultValue = def;
    }

    public short getBaseVal() {
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    public String getBaseValAsString() {
        if (!this.valid) {
            this.update();
        }
        return this.values[this.baseVal];
    }

    protected void update() {
        String val = this.element.getAttributeNS(this.namespaceURI, this.localName);
        this.baseVal = val.length() == 0 ? this.defaultValue : this.getEnumerationNumber(val);
        this.valid = true;
    }

    protected short getEnumerationNumber(String s) {
        short i = 0;
        while (i < this.values.length) {
            if (s.equals(this.values[i])) {
                return i;
            }
            i = (short)(i + 1);
        }
        return 0;
    }

    public void setBaseVal(short baseVal) throws DOMException {
        if (baseVal >= 0 && baseVal < this.values.length) {
            try {
                this.baseVal = baseVal;
                this.valid = true;
                this.changing = true;
                this.element.setAttributeNS(this.namespaceURI, this.localName, this.values[baseVal]);
                Object var3_2 = null;
                this.changing = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.changing = false;
                throw throwable;
            }
        }
    }

    public short getAnimVal() {
        if (this.hasAnimVal) {
            return this.animVal;
        }
        if (!this.valid) {
            this.update();
        }
        return this.baseVal;
    }

    public short getCheckedVal() {
        if (this.hasAnimVal) {
            return this.animVal;
        }
        if (!this.valid) {
            this.update();
        }
        if (this.baseVal == 0) {
            throw new LiveAttributeException(this.element, this.localName, 1, this.getBaseValAsString());
        }
        return this.baseVal;
    }

    public AnimatableValue getUnderlyingValue(AnimationTarget target) {
        return new AnimatableStringValue(target, this.getBaseValAsString());
    }

    public void attrAdded(Attr node, String newv) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected void updateAnimatedValue(AnimatableValue val) {
        if (val == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            this.animVal = this.getEnumerationNumber(((AnimatableStringValue)val).getString());
            this.fireAnimatedAttributeListeners();
        }
        this.fireAnimatedAttributeListeners();
    }

    public void attrModified(Attr node, String oldv, String newv) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr node, String oldv) {
        if (!this.changing) {
            this.valid = false;
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }
}

