/*
 * Decompiled with CFR 0.152.
 */
package gui.viewer;

import automata.Transition;
import gui.viewer.CurvedArrow;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;

public class InvisibleCurvedArrow
extends CurvedArrow {
    public InvisibleCurvedArrow(int n, int n2, int n3, int n4, float f, Transition transition) {
        super(n, n2, n3, n4, f, transition);
    }

    public InvisibleCurvedArrow(Point point, Point point2, float f, Transition transition) {
        super(point, point2, f, transition);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        this.drawText(graphics2D);
    }

    @Override
    public void drawHighlight(Graphics2D graphics2D) {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.setStroke(new BasicStroke(6.0f));
        graphics2D2.setColor(HIGHLIGHT_COLOR);
        graphics2D2.transform(this.affineToText);
        graphics2D2.fill(this.bounds);
        graphics2D2.dispose();
    }

    @Override
    public Rectangle2D getBounds() {
        Area area = new Area(this.bounds);
        area.transform(this.affineToText);
        return area.getBounds();
    }

    @Override
    public boolean isNear(Point point, int n) {
        if (this.needsRefresh) {
            this.refreshCurve();
        }
        try {
            if (this.bounds.contains(this.affineToText.inverseTransform(point, null))) {
                return true;
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return false;
    }
}

