/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import gui.tree.DefaultNodeDrawer;
import gui.tree.DefaultNodePlacer;
import gui.tree.NodeDrawer;
import gui.tree.NodePlacer;
import gui.tree.TreeDrawer;
import gui.tree.Trees;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class DefaultTreeDrawer
implements TreeDrawer,
TreeModelListener {
    private boolean inverted = false;
    private boolean valid = false;
    private TreeModel tree;
    private Map nodeToPoint = new HashMap();
    private boolean defaultVisible = true;
    private WeakHashMap visibleNodes = new WeakHashMap();
    private NodeDrawer nodeDrawer = new DefaultNodeDrawer();
    private NodePlacer nodePlacer = new DefaultNodePlacer();

    public DefaultTreeDrawer(TreeModel treeModel) {
        this.tree = treeModel;
        treeModel.addTreeModelListener(this);
    }

    protected Color getNodeColor(TreeNode treeNode) {
        return Color.yellow;
    }

    @Override
    public void draw(Graphics2D graphics2D, Dimension2D dimension2D) {
        if (!this.valid) {
            this.revalidate();
        }
        graphics2D = (Graphics2D)graphics2D.create();
        graphics2D.setFont(graphics2D.getFont().deriveFont(10.0f));
        graphics2D.setColor(Color.black);
        this.draw(graphics2D, (TreeNode)this.tree.getRoot(), dimension2D, null);
        graphics2D.dispose();
    }

    private Point2D scalePoint(Point2D point2D, Dimension2D dimension2D) {
        Point2D point2D2 = null;
        try {
            point2D2 = (Point2D)point2D.getClass().newInstance();
            if (this.inverted) {
                point2D2.setLocation(point2D.getX() * dimension2D.getWidth(), (1.0 - point2D.getY()) * dimension2D.getHeight());
            } else {
                point2D2.setLocation(point2D.getX() * dimension2D.getWidth(), point2D.getY() * dimension2D.getHeight());
            }
        }
        catch (Throwable throwable) {
            System.err.println("BADNESS SCALING THE POINT IN TREEDRAWER!");
            System.err.println(throwable);
        }
        return point2D2;
    }

    protected void draw(Graphics2D graphics2D, TreeNode treeNode, Dimension2D dimension2D, Point2D point2D) {
        boolean bl = this.isVisible(treeNode);
        Point2D point2D2 = this.scalePoint((Point2D)this.nodeToPoint.get(treeNode), dimension2D);
        if (bl && point2D != null) {
            graphics2D.drawLine((int)point2D.getX(), (int)point2D.getY(), (int)point2D2.getX(), (int)point2D2.getY());
        }
        TreeNode[] treeNodeArray = Trees.children(treeNode);
        for (int i = 0; i < treeNodeArray.length; ++i) {
            this.draw(graphics2D, treeNodeArray[i], dimension2D, bl ? point2D2 : null);
        }
        if (!bl) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.translate(point2D2.getX(), point2D2.getY());
        graphics2D2.setColor(this.getNodeColor(treeNode));
        this.nodeDrawer.draw(graphics2D2, treeNode);
        graphics2D2.dispose();
    }

    @Override
    public TreeModel getModel() {
        return this.tree;
    }

    public void setModel(TreeModel treeModel) {
        this.tree = treeModel;
        this.invalidate();
    }

    public void hideAll() {
        this.defaultVisible = false;
        this.visibleNodes.clear();
    }

    public void showAll() {
        this.defaultVisible = true;
        this.visibleNodes.clear();
    }

    public void show(TreeNode treeNode) {
        if (this.defaultVisible) {
            this.visibleNodes.remove(treeNode);
        } else {
            this.visibleNodes.put(treeNode, null);
        }
    }

    public void hide(TreeNode treeNode) {
        this.defaultVisible = !this.defaultVisible;
        this.show(treeNode);
        this.defaultVisible = !this.defaultVisible;
    }

    public boolean isVisible(TreeNode treeNode) {
        return this.defaultVisible ^ this.visibleNodes.containsKey(treeNode);
    }

    @Override
    public void invalidate() {
        this.valid = false;
    }

    @Override
    public void revalidate() {
        this.valid = true;
        this.nodeToPoint = this.nodePlacer.placeNodes(this.tree, this.nodeDrawer);
    }

    @Override
    public TreeNode nodeAtPoint(Point2D point2D, Dimension2D dimension2D) {
        for (Map.Entry entry : this.nodeToPoint.entrySet()) {
            Point2D point2D2 = this.scalePoint((Point2D)entry.getValue(), dimension2D);
            TreeNode treeNode = (TreeNode)entry.getKey();
            if (!this.nodeDrawer.onNode(treeNode, point2D.getX() - point2D2.getX(), point2D.getY() - point2D2.getY())) continue;
            return treeNode;
        }
        return null;
    }

    private void setPoints(TreeNode treeNode, int n, int n2, int[] nArray, int[] nArray2) {
        float f = (float)(nArray2[n2] + 1) / (float)(nArray[n2] + 1);
        float f2 = (float)(n2 + 1) / (float)(n + 2);
        this.nodeToPoint.put(treeNode, new Point2D.Float(f, f2));
        int n3 = n2++;
        nArray2[n3] = nArray2[n3] + 1;
        TreeNode[] treeNodeArray = Trees.children(treeNode);
        for (int i = 0; i < treeNodeArray.length; ++i) {
            this.setPoints(treeNodeArray[i], n, n2, nArray, nArray2);
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.invalidate();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.invalidate();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.invalidate();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.invalidate();
    }

    @Override
    public void setNodePlacer(NodePlacer nodePlacer) {
        this.nodePlacer = nodePlacer;
        this.invalidate();
    }

    @Override
    public NodePlacer getNodePlacer() {
        return this.nodePlacer;
    }

    @Override
    public void setNodeDrawer(NodeDrawer nodeDrawer) {
        this.nodeDrawer = nodeDrawer;
    }

    @Override
    public NodeDrawer getNodeDrawer() {
        return this.nodeDrawer;
    }

    public void setInverted(boolean bl) {
        this.inverted = bl;
    }

    public boolean isInverted() {
        return this.inverted;
    }
}

