/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import gui.SplitPaneFactory;
import gui.editor.ArrowDisplayOnlyTool;
import gui.environment.Environment;
import gui.sim.ConfigurationController;
import gui.sim.ConfigurationPane;
import gui.sim.ControlPanel;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimulatorPane
extends JPanel {
    private Automaton automaton;
    private AutomatonSimulator simulator;

    public SimulatorPane(Automaton automaton, AutomatonSimulator automatonSimulator, Configuration[] configurationArray, Environment environment, boolean bl) {
        this.automaton = automaton;
        this.simulator = automatonSimulator;
        this.initView(configurationArray, environment, bl);
    }

    private void initView(Configuration[] configurationArray, final Environment environment, boolean bl) {
        this.setLayout(new BorderLayout());
        SelectionDrawer selectionDrawer = new SelectionDrawer(this.automaton);
        AutomatonPane automatonPane = new AutomatonPane(selectionDrawer, true);
        ArrowDisplayOnlyTool arrowDisplayOnlyTool = new ArrowDisplayOnlyTool(automatonPane, selectionDrawer);
        automatonPane.addMouseListener(arrowDisplayOnlyTool);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(22, 31);
        ConfigurationPane configurationPane = new ConfigurationPane(this.automaton);
        configurationPane.setLayout(new GridLayout(0, 4));
        for (int i = 0; i < configurationArray.length; ++i) {
            configurationPane.add(configurationArray[i]);
        }
        final ConfigurationController configurationController = new ConfigurationController(configurationPane, this.simulator, selectionDrawer, automatonPane);
        environment.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (environment.contains(SimulatorPane.this)) {
                    return;
                }
                environment.removeChangeListener(this);
                configurationController.cleanup();
            }
        });
        ControlPanel controlPanel = new ControlPanel(configurationController);
        controlPanel.setBlock(bl);
        jScrollPane.getViewport().setView(configurationPane);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)controlPanel, "South");
        JSplitPane jSplitPane = SplitPaneFactory.createSplit(environment, false, 0.6, automatonPane, jPanel);
        this.add((Component)jSplitPane, "Center");
    }

    public void setAutomaton(Automaton automaton) {
        this.automaton = automaton;
    }
}

