/*
 * Decompiled with CFR 0.152.
 */
package gui.pumping;

import gui.pumping.PumpingLemmaInputPane;
import gui.pumping.SliderPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pumping.PumpingLemma;

public abstract class HumanFirstPane
extends PumpingLemmaInputPane {
    private static String OBJECTIVE = "Find a valid partition that can be pumped.";
    private static String PROMPT_M = "Please select a value for m in Box 1 and press \"Enter\".";
    private static String DESCRIBE_W = "I have selected w such that |w| >= m. It is displayed in Box 2.";
    private static String PROMPT_DECOMPOSITION = "Please select the decomposition of w in Box 3 using the sliders.";
    private static String DESCRIBE_I = "I have selected i to give a contradition. It is displayed in Box 4.";
    protected String decompButtonTitle;
    protected SliderPanel myXPanel;
    protected SliderPanel myYPanel;
    protected JButton myDecompButton;
    protected JTextArea myZDisplay;
    protected JTextArea myZLength;
    protected JTable myXYZDisplay;
    protected JPanel myXYZPanel;
    protected JPanel sliderPanel;

    public HumanFirstPane(PumpingLemma pumpingLemma, String string) {
        super(pumpingLemma, string);
        pumpingLemma.setFirstPlayer("Human");
    }

    @Override
    protected JPanel initDecompPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.sliderPanel = new JPanel();
        this.sliderPanel.setLayout(new BoxLayout(this.sliderPanel, 1));
        this.addDecompPanelGameFeatures(jPanel);
        this.myXPanel = new SliderPanel("x", this);
        this.sliderPanel.add(this.myXPanel);
        this.myYPanel = new SliderPanel("y", this);
        this.sliderPanel.add(this.myYPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 7));
        jPanel3.add(new JLabel("z: "));
        this.myZDisplay = new JTextArea(1, 30);
        this.myZDisplay.setEditable(false);
        jPanel3.add(this.myZDisplay);
        jPanel3.add(new JLabel("    |z|: "));
        this.myZLength = new JTextArea(1, 5);
        this.myZLength.setEditable(false);
        jPanel3.add(this.myZLength);
        this.sliderPanel.add(jPanel3);
        this.myXYZPanel = new JPanel(new BorderLayout());
        this.myXYZDisplay = new JTable(1, 1);
        this.myXYZDisplay.setEnabled(false);
        this.myXYZPanel.add(this.myXYZDisplay);
        this.myXYZPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 7));
        this.sliderPanel.add((Component)this.myXYZPanel, "South");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.stageMessages[3], "West");
        this.sliderPanel.add(jPanel4);
        jPanel2.add(this.sliderPanel);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        this.myDecompButton = new JButton(this.decompButtonTitle);
        this.myDecompButton.setEnabled(false);
        this.myDecompButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HumanFirstPane.this.stages[4].setVisible(true);
                HumanFirstPane.this.stages[5].setVisible(true);
                HumanFirstPane.this.resetMessages();
                HumanFirstPane.this.setI();
                HumanFirstPane.this.displayIEnd();
                if (HumanFirstPane.this.myLemma.isInLang(HumanFirstPane.this.myLemma.createPumpedString())) {
                    HumanFirstPane.this.myLemma.addAttempt(HumanFirstPane.this.myLemma.getDecompositionAsString() + "; I = " + HumanFirstPane.this.myLemma.getI() + "; <i>Won</i>");
                } else {
                    HumanFirstPane.this.myLemma.addAttempt(HumanFirstPane.this.myLemma.getDecompositionAsString() + "; I = " + HumanFirstPane.this.myLemma.getI() + "; <i>Failed</i>");
                }
                HumanFirstPane.this.updateTopPane(false);
                HumanFirstPane.this.leftPanel.revalidate();
                HumanFirstPane.this.setCanvas();
                HumanFirstPane.this.myCanvas.stop();
                if (HumanFirstPane.this.myCases != null) {
                    HumanFirstPane.this.myCases.setAddReplaceButtonsEnabled(true);
                }
            }
        });
        jPanel5.add(this.myDecompButton);
        jPanel2.add(jPanel5);
        jPanel.add((Component)jPanel2, "North");
        return jPanel;
    }

    public void updateTable() {
        this.myXYZPanel.remove(this.myXYZDisplay);
        this.myXYZDisplay = new JTable(1, this.myLemma.getW().length());
        this.myXYZDisplay.setEnabled(false);
        String string = this.myLemma.getW();
        for (int i = 0; i < string.length(); ++i) {
            this.myXYZDisplay.setValueAt(string.substring(i, i + 1), 0, i);
        }
        this.myXYZPanel.add((Component)this.myXYZDisplay, "Center");
    }

    @Override
    protected String addTopGameFeatures(JButton jButton) {
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HumanFirstPane.this.myMDisplay.setText("");
                HumanFirstPane.this.updateTopPane(false);
                HumanFirstPane.this.reset();
            }
        });
        return OBJECTIVE;
    }

    @Override
    protected String addMGameFeatures() {
        this.myMDisplay = new JTextField(10);
        ((JTextField)this.myMDisplay).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    HumanFirstPane.this.reset();
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    if (n < HumanFirstPane.this.myLemma.getRange()[0] || n > HumanFirstPane.this.myLemma.getRange()[1]) {
                        throw new NumberFormatException();
                    }
                    HumanFirstPane.this.myLemma.setM(n);
                    HumanFirstPane.this.stages[2].setVisible(true);
                    HumanFirstPane.this.stages[3].setVisible(true);
                    HumanFirstPane.this.mEnteredReset();
                    if (HumanFirstPane.this.myCases != null) {
                        HumanFirstPane.this.myCases.setListButtonEnabled(true);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "Please enter a positive integer in range [" + HumanFirstPane.this.myLemma.getRange()[0] + ", " + HumanFirstPane.this.myLemma.getRange()[1] + "] for best results.";
                    HumanFirstPane.this.myMDisplay.selectAll();
                    HumanFirstPane.this.stageMessages[1].setText(string);
                }
            }
        });
        return new String(PROMPT_M);
    }

    @Override
    protected String addWGameFeatures() {
        this.myWDisplay = new JTextArea(1, 20);
        this.myWDisplay.setEditable(false);
        return new String(DESCRIBE_W);
    }

    protected abstract void addDecompPanelGameFeatures(JPanel var1);

    @Override
    protected String addIGameFeatures() {
        this.myIDisplay = new JTextArea(1, 5);
        this.myIDisplay.setEditable(false);
        return new String(DESCRIBE_I);
    }

    @Override
    public void displayEnd() {
        String string = this.myLemma.createPumpedString();
        this.myPumpedStringDisplay.setText(string);
        if (this.myLemma.isInLang(string)) {
            this.myLastWord.setText(this.createXYZ() + " = " + PumpingLemmaInputPane.toHTMLString(string) + " = " + string + " is in the language.  YOU WIN!");
        } else {
            this.myLastWord.setText(this.createXYZ() + " = " + PumpingLemmaInputPane.toHTMLString(string) + " = " + string + " is NOT in the language.  Please try again.");
        }
    }

    protected abstract void mEnteredReset();

    protected abstract void refresh();

    protected abstract void setI();
}

