/*
 * Decompiled with CFR 0.152.
 */
package gui.minimize;

import automata.State;
import automata.Transition;
import automata.fsa.FiniteStateAutomaton;
import automata.fsa.MinimizeTreeNode;
import automata.fsa.Minimizer;
import automata.graph.AutomatonGraph;
import automata.graph.layout.GEMLayoutAlgorithm;
import gui.SplitPaneFactory;
import gui.SuperMouseAdapter;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBox;
import gui.editor.TransitionTool;
import gui.environment.Environment;
import gui.minimize.BuilderControlPanel;
import gui.minimize.BuilderController;
import gui.minimize.ControlPanel;
import gui.minimize.MinimizeController;
import gui.minimize.MinimizeNodeDrawer;
import gui.tree.SelectTreeDrawer;
import gui.tree.TreePanel;
import gui.tree.Trees;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class MinimizePane
extends JPanel {
    Minimizer minimizer;
    SelectionDrawer automatonDrawer;
    SelectTreeDrawer treeDrawer;
    MinimizeController controller;
    BuilderController builderController = null;
    JSplitPane split;
    ControlPanel controlPanel;
    JLabel messageLabel = new JLabel(" ");

    public MinimizePane(FiniteStateAutomaton finiteStateAutomaton, Environment environment) {
        this.minimizer = new Minimizer();
        this.minimizer.initializeMinimizer();
        finiteStateAutomaton = (FiniteStateAutomaton)this.minimizer.getMinimizeableAutomaton(finiteStateAutomaton);
        DefaultTreeModel defaultTreeModel = this.minimizer.getInitializedTree(finiteStateAutomaton);
        this.automatonDrawer = new SelectionDrawer(finiteStateAutomaton);
        this.treeDrawer = new SelectTreeDrawer(defaultTreeModel);
        MinimizeNodeDrawer minimizeNodeDrawer = new MinimizeNodeDrawer();
        this.treeDrawer.setNodeDrawer(minimizeNodeDrawer);
        TreeNode[] treeNodeArray = Trees.children((MinimizeTreeNode)defaultTreeModel.getRoot());
        for (int i = 0; i < treeNodeArray.length; ++i) {
            MinimizeTreeNode minimizeTreeNode = (MinimizeTreeNode)treeNodeArray[i];
            State[] stateArray = (State[])minimizeTreeNode.getUserObject();
            if (stateArray.length == 0) continue;
            if (finiteStateAutomaton.isFinalState(stateArray[0])) {
                minimizeNodeDrawer.setLabel(minimizeTreeNode, "Final");
                continue;
            }
            minimizeNodeDrawer.setLabel(minimizeTreeNode, "Nonfinal");
        }
        this.controller = new MinimizeController(this, this.automatonDrawer, this.treeDrawer, this.minimizer);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.initTreePane(), "Center");
        this.controlPanel = new ControlPanel(this.treeDrawer, this.controller);
        this.split = SplitPaneFactory.createSplit(environment, true, 0.5, this.initAutomatonPane(), jPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        this.add((Component)this.controlPanel, "North");
        this.add((Component)this.messageLabel, "South");
        this.split.setResizeWeight(0.5);
        this.controller.setEnabledness();
    }

    public AutomatonPane initAutomatonPane() {
        AutomatonPane automatonPane = new AutomatonPane(this.automatonDrawer);
        ArrowMinimizeTool arrowMinimizeTool = new ArrowMinimizeTool(automatonPane, this.automatonDrawer);
        automatonPane.addMouseListener(arrowMinimizeTool);
        automatonPane.addMouseMotionListener(arrowMinimizeTool);
        return automatonPane;
    }

    public TreePanel initTreePane() {
        final TreePanel treePanel = new TreePanel(this.treeDrawer);
        SuperMouseAdapter superMouseAdapter = new SuperMouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreeNode treeNode = treePanel.nodeAtPoint(mouseEvent.getPoint());
                MinimizePane.this.controller.nodeClicked((MinimizeTreeNode)treeNode, mouseEvent);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TreeNode treeNode = treePanel.nodeAtPoint(mouseEvent.getPoint());
                MinimizePane.this.controller.nodeDown((MinimizeTreeNode)treeNode, mouseEvent);
            }
        };
        treePanel.addMouseListener(superMouseAdapter);
        treePanel.addMouseMotionListener(superMouseAdapter);
        return treePanel;
    }

    public void beginMinimizedAutomaton(FiniteStateAutomaton finiteStateAutomaton, DefaultTreeModel defaultTreeModel) {
        Object object2;
        this.remove(this.controlPanel);
        FiniteStateAutomaton finiteStateAutomaton2 = new FiniteStateAutomaton();
        this.minimizer.createStatesForMinimumDfa(finiteStateAutomaton, finiteStateAutomaton2, defaultTreeModel);
        SelectionDrawer selectionDrawer = new SelectionDrawer(finiteStateAutomaton2);
        EditorPane editorPane = new EditorPane(selectionDrawer, new ToolBox(){

            @Override
            public List tools(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
                LinkedList<Tool> linkedList = new LinkedList<Tool>();
                linkedList.add(new ArrowMinimizeTool(automatonPane, automatonDrawer));
                linkedList.add(new TransitionTool(automatonPane, automatonDrawer));
                return linkedList;
            }
        });
        this.automatonDrawer.clearSelected();
        this.builderController = new BuilderController(finiteStateAutomaton, finiteStateAutomaton2, selectionDrawer, this.minimizer, defaultTreeModel, this.split);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)editorPane, "Center");
        editorPane.getToolBar().addSeparator();
        BuilderControlPanel.initView(editorPane.getToolBar(), this.builderController);
        this.split.setRightComponent(jPanel);
        this.invalidate();
        this.repaint();
        AutomatonGraph automatonGraph = new AutomatonGraph(finiteStateAutomaton2);
        automatonGraph.addVertex(finiteStateAutomaton2.getInitialState(), new Point(0, 0));
        for (Object object2 : this.builderController.remainingTransitions) {
            automatonGraph.addEdge(((Transition)object2).getFromState(), ((Transition)object2).getToState());
        }
        object2 = new GEMLayoutAlgorithm();
        HashSet<State> hashSet = new HashSet<State>();
        hashSet.add(finiteStateAutomaton2.getInitialState());
        ((GEMLayoutAlgorithm)object2).layout(automatonGraph, hashSet);
        automatonGraph.moveAutomatonStates();
        this.validate();
        editorPane.getAutomatonPane().fitToBounds(10);
    }

    private class ArrowMinimizeTool
    extends ArrowNontransitionTool {
        public ArrowMinimizeTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
            super(automatonPane, automatonDrawer);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            State state = MinimizePane.this.automatonDrawer.stateAtPoint(mouseEvent.getPoint());
            if (MinimizePane.this.builderController == null) {
                MinimizePane.this.controller.stateDown(state, mouseEvent);
            }
        }
    }
}

