/*
 * Decompiled with CFR 0.152.
 */
package gui.menu;

import automata.Automaton;
import automata.fsa.FiniteStateAutomaton;
import grammar.TuringChecker;
import gui.action.AboutAction;
import gui.action.AddTrapStateToDFAAction;
import gui.action.AutomatonAction;
import gui.action.BruteParseAction;
import gui.action.BuildingBlockSimulateAction;
import gui.action.CYKParseAction;
import gui.action.CloseAction;
import gui.action.CloseButton;
import gui.action.CloseWindowAction;
import gui.action.CombineAutomaton;
import gui.action.ConvertCFGLL;
import gui.action.ConvertCFGLR;
import gui.action.ConvertFSAToGrammarAction;
import gui.action.ConvertFSAToREAction;
import gui.action.ConvertPDAToGrammarAction;
import gui.action.ConvertRegularGrammarToFSA;
import gui.action.DFAEqualityAction;
import gui.action.GrammarTransformAction;
import gui.action.GrammarTypeTestAction;
import gui.action.LLParseTableAction;
import gui.action.LRParseTableAction;
import gui.action.LSystemDisplay;
import gui.action.LambdaHighlightAction;
import gui.action.LayoutAlgorithmAction;
import gui.action.LayoutStorageAction;
import gui.action.MinimizeTreeAction;
import gui.action.MultipleBruteParseAction;
import gui.action.MultipleCYKParseAction;
import gui.action.MultipleOutputSimulateAction;
import gui.action.MultipleSimulateAction;
import gui.action.NFAToDFAAction;
import gui.action.NewAction;
import gui.action.NoInteractionSimulateAction;
import gui.action.NondeterminismAction;
import gui.action.OpenAction;
import gui.action.OpenURLAction;
import gui.action.PrintAction;
import gui.action.QuitAction;
import gui.action.REToFSAAction;
import gui.action.RestrictedAction;
import gui.action.SaveAction;
import gui.action.SaveAsAction;
import gui.action.SaveGraphBMPAction;
import gui.action.SaveGraphGIFAction;
import gui.action.SaveGraphJPGAction;
import gui.action.SaveGraphPNGAction;
import gui.action.SimulateAction;
import gui.action.SimulateNoClosureAction;
import gui.action.TuringBruteParseAction;
import gui.action.TuringToUnrestrictGrammarAction;
import gui.action.UserControlParseAction;
import gui.environment.AutomatonEnvironment;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.LSystemEnvironment;
import gui.environment.RegularEnvironment;
import gui.environment.Universe;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class MenuBarCreator {
    public static JMenuBar getMenuBar(EnvironmentFrame environmentFrame) {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = MenuBarCreator.getFileMenu(environmentFrame);
        if (jMenu.getItemCount() > 0) {
            jMenuBar.add(jMenu);
        }
        if ((jMenu = MenuBarCreator.getInputMenu(environmentFrame)).getItemCount() > 0) {
            jMenuBar.add(jMenu);
        }
        if ((jMenu = MenuBarCreator.getTestMenu(environmentFrame)).getItemCount() > 0) {
            jMenuBar.add(jMenu);
        }
        if ((jMenu = MenuBarCreator.getViewMenu(environmentFrame)).getItemCount() > 0) {
            jMenuBar.add(jMenu);
        }
        if ((jMenu = MenuBarCreator.getConvertMenu(environmentFrame)).getItemCount() > 0) {
            jMenuBar.add(jMenu);
        }
        if ((jMenu = MenuBarCreator.getHelpMenu(environmentFrame)).getItemCount() > 0) {
            jMenuBar.add(jMenu);
        }
        CloseButton closeButton = new CloseButton(environmentFrame.getEnvironment());
        jMenuBar.add(Box.createGlue());
        jMenuBar.add(closeButton);
        return jMenuBar;
    }

    public static JMenuBar getMenuBar(EnvironmentFrame environmentFrame, int n) {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = MenuBarCreator.getFileMenu(environmentFrame);
        if (jMenu.getItemCount() > 0) {
            jMenuBar.add(jMenu);
        }
        if ((jMenu = MenuBarCreator.getInputMenu(environmentFrame, n)).getItemCount() > 0) {
            jMenuBar.add(jMenu);
        }
        if ((jMenu = MenuBarCreator.getTestMenu(environmentFrame)).getItemCount() > 0) {
            jMenuBar.add(jMenu);
        }
        if ((jMenu = MenuBarCreator.getViewMenu(environmentFrame)).getItemCount() > 0) {
            jMenuBar.add(jMenu);
        }
        if ((jMenu = MenuBarCreator.getConvertMenu(environmentFrame, n)).getItemCount() > 0) {
            jMenuBar.add(jMenu);
        }
        if ((jMenu = MenuBarCreator.getHelpMenu(environmentFrame)).getItemCount() > 0) {
            jMenuBar.add(jMenu);
        }
        CloseButton closeButton = new CloseButton(environmentFrame.getEnvironment());
        jMenuBar.add(Box.createGlue());
        jMenuBar.add(closeButton);
        return jMenuBar;
    }

    public static void addItem(JMenu jMenu, Action action) {
        JMenuItem jMenuItem = new JMenuItem(action);
        jMenuItem.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
        jMenu.add(jMenuItem);
    }

    private static JMenu getFileMenu(EnvironmentFrame environmentFrame) {
        Environment environment = environmentFrame.getEnvironment();
        JMenu jMenu = new JMenu("File");
        MenuBarCreator.addItem(jMenu, new NewAction());
        SecurityManager securityManager = System.getSecurityManager();
        if (Universe.CHOOSER != null) {
            MenuBarCreator.addItem(jMenu, new OpenAction());
            MenuBarCreator.addItem(jMenu, new SaveAction(environment));
            MenuBarCreator.addItem(jMenu, new SaveAsAction(environment));
            JMenu jMenu2 = new JMenu("Save Image As...");
            jMenu2.add(new SaveGraphJPGAction(environment, jMenu));
            jMenu2.add(new SaveGraphPNGAction(environment, jMenu));
            jMenu2.add(new SaveGraphGIFAction(environment, jMenu));
            jMenu2.add(new SaveGraphBMPAction(environment, jMenu));
            if (environment instanceof AutomatonEnvironment) {
                JarFile jarFile = null;
                try {
                    if (new File("JFLAP.jar").exists()) {
                        jarFile = new JarFile("JFLAP.jar");
                    } else if (new File("JFLAP_With_Source.jar").exists()) {
                        jarFile = new JarFile("JFLAP_With_Source.jar");
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                if (new File("svg.jar").exists() || jarFile != null && jarFile.getJarEntry("org/foo.txt") != null) {
                    try {
                        RestrictedAction restrictedAction = (RestrictedAction)Class.forName("gui.action.ExportAction").getConstructor(Environment.class).newInstance(environment);
                        jMenu2.add(restrictedAction);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        System.err.println("Cannot make menu");
                    }
                }
            }
            jMenu.add(jMenu2);
        } else {
            MenuBarCreator.addItem(jMenu, new OpenURLAction());
        }
        MenuBarCreator.addItem(jMenu, new CloseAction(environment));
        MenuBarCreator.addItem(jMenu, new CloseWindowAction(environmentFrame));
        try {
            if (securityManager != null) {
                securityManager.checkPrintJobAccess();
            }
            MenuBarCreator.addItem(jMenu, new PrintAction(environment));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            if (securityManager != null) {
                securityManager.checkExit(0);
            }
            MenuBarCreator.addItem(jMenu, new QuitAction());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return jMenu;
    }

    private static JMenu getInputMenu(EnvironmentFrame environmentFrame) {
        boolean bl;
        Environment environment = environmentFrame.getEnvironment();
        JMenu jMenu = new JMenu("Input");
        Serializable serializable = environment.getObject();
        if (SimulateAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new SimulateAction((Automaton)serializable, environment));
        }
        if (BuildingBlockSimulateAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new BuildingBlockSimulateAction((Automaton)serializable, environment));
        }
        if (SimulateNoClosureAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new SimulateNoClosureAction((Automaton)serializable, environment));
        }
        if (NoInteractionSimulateAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new NoInteractionSimulateAction((Automaton)serializable, environment));
        }
        if (MultipleSimulateAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new MultipleSimulateAction((Automaton)serializable, environment));
        }
        if (MultipleOutputSimulateAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new MultipleOutputSimulateAction((Automaton)serializable, environment));
        }
        if (bl = TuringChecker.check(serializable)) {
            return MenuBarCreator.getInputMenu(environmentFrame, 0);
        }
        if (LLParseTableAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new LLParseTableAction((GrammarEnvironment)environment));
        }
        if (LRParseTableAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new LRParseTableAction((GrammarEnvironment)environment));
        }
        if (BruteParseAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new BruteParseAction((GrammarEnvironment)environment));
        }
        if (MultipleBruteParseAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new MultipleBruteParseAction((GrammarEnvironment)environment));
        }
        if (UserControlParseAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new UserControlParseAction((GrammarEnvironment)environment));
        }
        if (CYKParseAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new CYKParseAction((GrammarEnvironment)environment));
        }
        if (MultipleCYKParseAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new MultipleCYKParseAction((GrammarEnvironment)environment));
        }
        if (LSystemDisplay.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new LSystemDisplay((LSystemEnvironment)environment));
        }
        return jMenu;
    }

    private static JMenu getInputMenu(EnvironmentFrame environmentFrame, int n) {
        Environment environment = environmentFrame.getEnvironment();
        JMenu jMenu = new JMenu("Input");
        Serializable serializable = environment.getObject();
        if (UserControlParseAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new UserControlParseAction((GrammarEnvironment)environment));
        }
        if (TuringBruteParseAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new TuringBruteParseAction((GrammarEnvironment)environment));
        }
        return jMenu;
    }

    private static JMenu getViewMenu(EnvironmentFrame environmentFrame) {
        Environment environment = environmentFrame.getEnvironment();
        JMenu jMenu = new JMenu("View");
        Serializable serializable = environment.getObject();
        if (AutomatonAction.isApplicable(serializable)) {
            Automaton automaton = (Automaton)serializable;
            LayoutStorageAction layoutStorageAction = new LayoutStorageAction("Save Current Graph Layout", "Restore Saved Graph Layout", automaton);
            jMenu.add(layoutStorageAction);
            jMenu.add(layoutStorageAction.getRestoreAction());
            JMenu jMenu2 = new JMenu("Move Vertices");
            JMenu jMenu3 = new JMenu("Reflect Across Line...");
            jMenu3.add(new LayoutAlgorithmAction("Horizontal Line Through Center", automaton, environment, -10));
            jMenu3.add(new LayoutAlgorithmAction("Vertical Line Through Center", automaton, environment, -11));
            jMenu3.add(new LayoutAlgorithmAction("Diagonal From Upper-Left To Lower-Right", automaton, environment, -12));
            jMenu3.add(new LayoutAlgorithmAction("Diagonal From Lower-Left To Upper-Right", automaton, environment, -13));
            jMenu2.add(jMenu3);
            jMenu2.add(new LayoutAlgorithmAction("Rotate The Graph", automaton, environment, -14));
            jMenu2.add(new LayoutAlgorithmAction("Fill Screen With Graph", automaton, environment, -15));
            jMenu.add(jMenu2);
            jMenu.add(new LayoutAlgorithmAction("Apply A Random Layout Algorithm", automaton, environment, -1));
            jMenu2 = new JMenu("Apply A Specific Layout Algorithm");
            jMenu2.add(new LayoutAlgorithmAction("Circle", automaton, environment, 0));
            jMenu2.add(new LayoutAlgorithmAction("GEM", automaton, environment, 1));
            jMenu2.add(new LayoutAlgorithmAction("Random", automaton, environment, 2));
            jMenu2.add(new LayoutAlgorithmAction("Spiral", automaton, environment, 3));
            jMenu3 = new JMenu("Tree");
            jMenu3.add(new LayoutAlgorithmAction("Degree", automaton, environment, 5));
            jMenu3.add(new LayoutAlgorithmAction("Hierarchy", automaton, environment, 4));
            jMenu2.add(jMenu3);
            jMenu2.add(new LayoutAlgorithmAction("Two Circle", automaton, environment, 6));
            jMenu.add(jMenu2);
        }
        return jMenu;
    }

    private static JMenu getTestMenu(EnvironmentFrame environmentFrame) {
        Environment environment = environmentFrame.getEnvironment();
        JMenu jMenu = new JMenu("Test");
        Serializable serializable = environment.getObject();
        if (DFAEqualityAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new DFAEqualityAction((FiniteStateAutomaton)serializable, environment));
        }
        if (NondeterminismAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new NondeterminismAction((Automaton)serializable, environment));
        }
        if (LambdaHighlightAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new LambdaHighlightAction((Automaton)serializable, environment));
        }
        if (GrammarTypeTestAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new GrammarTypeTestAction((GrammarEnvironment)environment));
        }
        return jMenu;
    }

    private static JMenu getConvertMenu(EnvironmentFrame environmentFrame) {
        Environment environment = environmentFrame.getEnvironment();
        JMenu jMenu = new JMenu("Convert");
        Serializable serializable = environment.getObject();
        boolean bl = TuringChecker.check(serializable);
        if (bl) {
            return MenuBarCreator.getConvertMenu(environmentFrame, 0);
        }
        if (NFAToDFAAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new NFAToDFAAction((FiniteStateAutomaton)serializable, environment));
        }
        if (MinimizeTreeAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new MinimizeTreeAction((FiniteStateAutomaton)serializable, environment));
        }
        if (ConvertFSAToGrammarAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new ConvertFSAToGrammarAction((AutomatonEnvironment)environment));
        }
        if (ConvertPDAToGrammarAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new ConvertPDAToGrammarAction((AutomatonEnvironment)environment));
        }
        if (ConvertFSAToREAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new ConvertFSAToREAction((AutomatonEnvironment)environment));
        }
        if (ConvertCFGLL.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new ConvertCFGLL((GrammarEnvironment)environment));
        }
        if (ConvertCFGLR.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new ConvertCFGLR((GrammarEnvironment)environment));
        }
        if (ConvertRegularGrammarToFSA.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new ConvertRegularGrammarToFSA((GrammarEnvironment)environment));
        }
        if (GrammarTransformAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new GrammarTransformAction((GrammarEnvironment)environment));
        }
        if (REToFSAAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new REToFSAAction((RegularEnvironment)environment));
        }
        if (CombineAutomaton.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new CombineAutomaton((AutomatonEnvironment)environment));
        }
        if (TuringToUnrestrictGrammarAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new TuringToUnrestrictGrammarAction((AutomatonEnvironment)environment));
        }
        if (AddTrapStateToDFAAction.isApplicable(serializable)) {
            MenuBarCreator.addItem(jMenu, new AddTrapStateToDFAAction((AutomatonEnvironment)environment));
        }
        return jMenu;
    }

    private static JMenu getConvertMenu(EnvironmentFrame environmentFrame, int n) {
        Environment environment = environmentFrame.getEnvironment();
        JMenu jMenu = new JMenu("Convert");
        Serializable serializable = environment.getObject();
        return jMenu;
    }

    private static JMenu getHelpMenu(EnvironmentFrame environmentFrame) {
        Environment environment = environmentFrame.getEnvironment();
        JMenu jMenu = new JMenu("Help");
        Serializable serializable = environment.getObject();
        MenuBarCreator.addItem(jMenu, new AbstractAction("Help..."){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(null, "For help, feel free to access the JFLAP tutorial at\n                          www.jflap.org.", "Help", -1);
            }
        });
        MenuBarCreator.addItem(jMenu, new AboutAction());
        return jMenu;
    }
}

