/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.transform;

import automata.State;
import automata.Transition;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import automata.vdg.VariableDependencyGraph;
import grammar.Grammar;
import grammar.Production;
import grammar.ProductionChecker;
import grammar.UnitProductionRemover;
import gui.grammar.GrammarTableModel;
import gui.grammar.transform.UnitPane;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JOptionPane;

public class UnitController {
    UnitPane pane;
    Grammar grammar;
    UnitProductionRemover remover = new UnitProductionRemover();
    VariableDependencyGraph vdg;
    Set vdgTransitions = new HashSet();
    Set desiredProductions = new HashSet();
    Set currentProductions = new HashSet();
    Set unitProductions = new HashSet();
    int step = 0;
    static final int VARAIBLE_GRAPH = 1;
    static final int PRODUCTION_MODIFY = 2;
    static final int FINISHED = 3;

    public UnitController(UnitPane unitPane, Grammar grammar) {
        this.pane = unitPane;
        this.grammar = grammar;
        this.nextStep();
    }

    private void nextStep() {
        if (this.step != 3) {
            ++this.step;
        }
        switch (this.step) {
            case 1: {
                this.pane.mainLabel.setText("Complete unit production visualization.");
                this.pane.detailLabel.setText("For every unit production, connect start and end.");
                this.vdg = new VariableDependencyGraph();
                this.remover.initializeDependencyGraph(this.vdg, this.grammar);
                Production[] productionArray = this.grammar.getProductions();
                for (int i = 0; i < productionArray.length; ++i) {
                    if (!ProductionChecker.isUnitProduction(productionArray[i])) continue;
                    this.vdgTransitions.add(this.remover.getTransitionForUnitProduction(productionArray[i], this.vdg));
                }
                this.vdg.addTransitionListener(new AutomataTransitionListener(){

                    @Override
                    public void automataTransitionChange(AutomataTransitionEvent automataTransitionEvent) {
                        if (!automataTransitionEvent.isAdd()) {
                            return;
                        }
                        if (UnitController.this.vdgTransitions.contains(automataTransitionEvent.getTransition())) {
                            UnitController.this.vdgTransitions.remove(automataTransitionEvent.getTransition());
                            UnitController.this.updateDisplay();
                            return;
                        }
                        JOptionPane.showMessageDialog(UnitController.this.pane, "Transition is not part of VDG.", "Bad Transition", 0);
                        UnitController.this.vdg.removeTransition(automataTransitionEvent.getTransition());
                    }
                });
                this.pane.deleteAction.setEnabled(false);
                this.pane.completeSelectedAction.setEnabled(false);
                this.pane.doStepAction.setEnabled(true);
                this.pane.doAllAction.setEnabled(true);
                this.pane.proceedAction.setEnabled(false);
                this.pane.exportAction.setEnabled(false);
                this.updateDisplay();
                break;
            }
            case 2: {
                this.pane.updateDeleteEnabledness();
                this.pane.updateCompleteSelectedEnabledness();
                this.pane.mainLabel.setText("Modify the grammar to remove unit productions.");
                Production[] productionArray = this.grammar.getProductions();
                for (int i = 0; i < productionArray.length; ++i) {
                    this.pane.editingGrammarModel.addProduction(productionArray[i]);
                    this.currentProductions.add(productionArray[i]);
                    if (!ProductionChecker.isUnitProduction(productionArray[i])) continue;
                    this.unitProductions.add(productionArray[i]);
                }
                Grammar grammar = this.remover.getUnitProductionlessGrammar(this.grammar, this.vdg);
                productionArray = grammar.getProductions();
                for (int i = 0; i < productionArray.length; ++i) {
                    this.desiredProductions.add(productionArray[i]);
                }
                this.updateDisplay();
                this.pane.editingActive = true;
                break;
            }
            case 3: {
                this.pane.editingActive = false;
                this.pane.deleteAction.setEnabled(false);
                this.pane.completeSelectedAction.setEnabled(false);
                this.pane.mainLabel.setText("Unit removal complete.");
                this.pane.detailLabel.setText("\"Proceed\" or \"Export\" available.");
                this.pane.doStepAction.setEnabled(false);
                this.pane.doAllAction.setEnabled(false);
                this.pane.proceedAction.setEnabled(true);
                this.pane.exportAction.setEnabled(true);
            }
        }
    }

    void doSelected() {
        this.pane.editingActive = false;
        int[] nArray = this.pane.editingGrammarView.getSelectedRows();
        GrammarTableModel grammarTableModel = this.pane.editingGrammarModel;
        HashSet hashSet = new HashSet();
        for (int i = nArray.length - 1; i >= 0; --i) {
            Production production = grammarTableModel.getProduction(nArray[i]);
            if (!ProductionChecker.isUnitProduction(production)) continue;
            hashSet.add(production);
            this.pane.editingGrammarModel.deleteRow(nArray[i]);
            this.unitProductions.remove(production);
            this.currentProductions.remove(production);
        }
        HashSet<Production> hashSet2 = new HashSet<Production>();
        for (Production production : hashSet) {
            for (Production production2 : this.desiredProductions) {
                if (!production2.getLHS().equals(production.getRHS())) continue;
                hashSet2.add(new Production(production.getLHS(), production2.getRHS()));
            }
        }
        for (Production production : hashSet2) {
            if (!this.currentProductions.add(production)) continue;
            this.pane.editingGrammarModel.addProduction(production);
        }
        this.pane.editingActive = true;
        if (((Object)this.currentProductions).equals(this.desiredProductions)) {
            this.nextStep();
        } else {
            this.updateDisplay();
        }
    }

    public void doStep() {
        switch (this.step) {
            case 1: {
                Transition[] transitionArray = this.vdgTransitions.toArray(new Transition[0]);
                for (int i = 0; i < transitionArray.length; ++i) {
                    this.vdg.addTransition(transitionArray[i]);
                }
                break;
            }
            case 2: {
                for (int i = this.pane.editingGrammarModel.getRowCount() - 2; i >= 0; --i) {
                    Production production = this.pane.editingGrammarModel.getProduction(i);
                    if (!this.unitProductions.contains(production)) continue;
                    this.pane.editingGrammarModel.deleteRow(i);
                    this.unitProductions.remove(production);
                }
                this.pane.editingActive = false;
                Production[] productionArray = this.desiredProductions.toArray(new Production[0]);
                for (int i = 0; i < productionArray.length; ++i) {
                    if (!this.currentProductions.add(productionArray[i])) continue;
                    this.pane.editingGrammarModel.addProduction(productionArray[i]);
                }
                this.nextStep();
                break;
            }
        }
    }

    public void doAll() {
        while (this.step != 3) {
            this.doStep();
        }
    }

    public Grammar getGrammar() {
        return this.pane.getGrammar();
    }

    void updateDisplay() {
        switch (this.step) {
            case 1: {
                int n = this.vdgTransitions.size();
                this.pane.detailLabel.setText(n + " more transition(s) needed.");
                if (n != 0) break;
                this.nextStep();
                break;
            }
            case 2: {
                int n = this.unitProductions.size();
                int n2 = this.desiredProductions.size() - this.currentProductions.size() + n;
                this.pane.detailLabel.setText(n + " more remove" + (n == 1 ? "" : "s") + ", and " + n2 + " more addition" + (n2 == 1 ? "" : "s") + " needed.");
                if (n2 != 0 || n != 0) break;
                this.nextStep();
                break;
            }
        }
    }

    boolean productionAdded(Production production, int n) {
        if (this.currentProductions.contains(production)) {
            JOptionPane.showMessageDialog(this.pane, "This production is already in the grammar.", "Production Already Here", 0);
            return false;
        }
        if (!this.desiredProductions.contains(production)) {
            JOptionPane.showMessageDialog(this.pane, "This production is not part of the reformed grammar.", "Production Not Desired", 0);
            return false;
        }
        this.currentProductions.add(production);
        this.updateDisplay();
        return true;
    }

    void stateClicked(State state, MouseEvent mouseEvent) {
        if (mouseEvent.isShiftDown()) {
            if (state == null) {
                return;
            }
            if (this.pane.vdgDrawer.isSelected(state)) {
                this.pane.vdgDrawer.removeSelected(state);
            } else {
                this.pane.vdgDrawer.addSelected(state);
            }
        } else if (state == null) {
            this.pane.vdgDrawer.clearSelected();
        } else if (!this.pane.vdgDrawer.isSelected(state)) {
            this.pane.vdgDrawer.clearSelected();
            this.pane.vdgDrawer.addSelected(state);
        }
        this.pane.vdgEditor.repaint();
        this.pane.completeSelectedAction.setEnabled(this.pane.vdgDrawer.numberSelected() > 0);
    }

    boolean productionDeleted(Production production, int n) {
        if (!ProductionChecker.isUnitProduction(production)) {
            return false;
        }
        this.unitProductions.remove(production);
        this.currentProductions.remove(production);
        return true;
    }
}

