/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.parse;

import automata.fsa.FiniteStateAutomaton;
import grammar.Grammar;
import grammar.parse.LRParseTable;
import grammar.parse.Operations;
import gui.SplitPaneFactory;
import gui.editor.ArrowNontransitionTool;
import gui.editor.EditorPane;
import gui.editor.Tool;
import gui.editor.ToolBox;
import gui.environment.GrammarEnvironment;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.parse.FirstFollowTable;
import gui.grammar.parse.GotoTransitionTool;
import gui.grammar.parse.LRParseDerivationController;
import gui.grammar.parse.LRParseTableChooserPane;
import gui.viewer.AutomatonDraggerPane;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

public class LRParseTableDerivationPane
extends JPanel {
    private Grammar augmentedGrammar;
    private LRParseDerivationController controller;
    private FiniteStateAutomaton dfa;
    private JSplitPane split;
    private JSplitPane split2;
    private LRParseTableChooserPane tableView;

    public LRParseTableDerivationPane(GrammarEnvironment grammarEnvironment) {
        super(new BorderLayout());
        EditorPane editorPane;
        Grammar grammar = grammarEnvironment.getGrammar();
        this.augmentedGrammar = Operations.getAugmentedGrammar(grammar);
        if (this.augmentedGrammar == null) {
            return;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel();
        jPanel.add((Component)jLabel, "North");
        FirstFollowTable firstFollowTable = new FirstFollowTable(grammar);
        firstFollowTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        jPanel.add(new JScrollPane(firstFollowTable));
        firstFollowTable.getFFModel().setCanEditFirst(true);
        firstFollowTable.getFFModel().setCanEditFollow(true);
        this.dfa = new FiniteStateAutomaton();
        this.controller = new LRParseDerivationController(grammar, this.augmentedGrammar, grammarEnvironment, firstFollowTable, jLabel, this.dfa, this);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.controller.editor = editorPane = this.createEditor(jPanel2);
        jPanel2.add((Component)editorPane, "Center");
        this.split = SplitPaneFactory.createSplit(grammarEnvironment, false, 0.4, new JScrollPane(firstFollowTable), jPanel2);
        this.split2 = SplitPaneFactory.createSplit(grammarEnvironment, false, 0.7, this.split, null);
        jPanel.add((Component)this.split2, "Center");
        GrammarTable grammarTable = new GrammarTable(new GrammarTableModel(this.augmentedGrammar){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        }){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                try {
                    int n = this.rowAtPoint(mouseEvent.getPoint());
                    return this.getGrammarModel().getProduction(n).toString() + " is production " + n;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        JSplitPane jSplitPane = SplitPaneFactory.createSplit(grammarEnvironment, true, 0.3, grammarTable, jPanel);
        this.add((Component)jSplitPane, "Center");
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.controller.doSelectedAction);
        jToolBar.add(this.controller.doStepAction);
        jToolBar.add(this.controller.doAllAction);
        jToolBar.addSeparator();
        jToolBar.add(this.controller.nextAction);
        jToolBar.addSeparator();
        jToolBar.add(this.controller.parseAction);
        this.add((Component)jToolBar, "North");
    }

    private EditorPane createEditor(Component component) {
        SelectionDrawer selectionDrawer = new SelectionDrawer(this.dfa);
        EditorPane editorPane = new EditorPane(selectionDrawer, new ToolBox(){

            @Override
            public List tools(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
                LinkedList<Tool> linkedList = new LinkedList<Tool>();
                linkedList.add(new ArrowNontransitionTool(automatonPane, automatonDrawer){

                    @Override
                    public boolean shouldAllowOnlyFinalStateChange() {
                        return true;
                    }

                    @Override
                    public boolean shouldShowStatePopup() {
                        return true;
                    }
                });
                linkedList.add(new GotoTransitionTool(automatonPane, automatonDrawer, LRParseTableDerivationPane.this.controller));
                return linkedList;
            }
        });
        return editorPane;
    }

    void moveDFA() {
        AutomatonDraggerPane automatonDraggerPane = new AutomatonDraggerPane(this.dfa);
        this.split.setRightComponent(automatonDraggerPane);
    }

    void setParseTable(LRParseTable lRParseTable) {
        if (this.tableView == null) {
            this.tableView = new LRParseTableChooserPane(lRParseTable);
            this.split2.setRightComponent(new JScrollPane(this.tableView));
        } else {
            this.tableView.setModel(lRParseTable);
        }
    }

    LRParseTableChooserPane getParseTableView() {
        return this.tableView;
    }

    public Grammar getAugmentedGrammar() {
        return this.augmentedGrammar;
    }
}

