/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.convert;

import automata.Automaton;
import automata.Transition;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import grammar.Grammar;
import grammar.Production;
import gui.environment.FrameFactory;
import gui.event.SelectionEvent;
import gui.event.SelectionListener;
import gui.grammar.convert.GrammarViewer;
import gui.viewer.SelectionDrawer;
import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

class ConvertController {
    protected GrammarViewer grammarView;
    protected SelectionDrawer drawer;
    protected Grammar grammar;
    protected Automaton automaton;
    protected Map pToT;
    protected Map tToP;
    protected Set alreadyDone = new HashSet();
    protected Component parent;

    public ConvertController(GrammarViewer grammarViewer, SelectionDrawer selectionDrawer, Map map, Component component) {
        this.grammarView = grammarViewer;
        this.drawer = selectionDrawer;
        this.parent = component;
        this.grammar = grammarViewer.getGrammar();
        this.automaton = selectionDrawer.getAutomaton();
        this.initListeners();
        this.pToT = map;
        this.tToP = this.invert(this.pToT);
    }

    private Map invert(Map map) {
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        Map map2 = null;
        try {
            map2 = (Map)map.getClass().newInstance();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                map2.put(entry.getValue(), entry.getKey());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return map2;
    }

    private void initListeners() {
        this.automaton.addTransitionListener(new AutomataTransitionListener(){

            @Override
            public void automataTransitionChange(AutomataTransitionEvent automataTransitionEvent) {
                if (!automataTransitionEvent.isAdd()) {
                    return;
                }
                Transition transition = automataTransitionEvent.getTransition();
                if (!ConvertController.this.tToP.containsKey(transition) || ConvertController.this.alreadyDone.contains(ConvertController.this.tToP.get(transition))) {
                    JOptionPane.showMessageDialog(ConvertController.this.parent, "That transition is not correct!");
                    ConvertController.this.automaton.removeTransition(transition);
                } else {
                    Production production = (Production)ConvertController.this.tToP.get(transition);
                    ConvertController.this.alreadyDone.add(production);
                    ConvertController.this.grammarView.setChecked(production, true);
                }
            }
        });
        this.grammarView.addSelectionListener(new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent selectionEvent) {
                Production[] productionArray = ConvertController.this.grammarView.getSelected();
                ConvertController.this.drawer.clearSelected();
                for (int i = 0; i < productionArray.length; ++i) {
                    ConvertController.this.drawer.addSelected((Transition)ConvertController.this.pToT.get(productionArray[i]));
                }
                ConvertController.this.parent.repaint();
            }
        });
    }

    public void complete() {
        HashSet hashSet = new HashSet(this.pToT.keySet());
        for (Production production : hashSet) {
            if (this.alreadyDone.contains(production)) continue;
            Transition transition = (Transition)this.pToT.get(production);
            this.automaton.addTransition(transition);
        }
    }

    public void createForSelected() {
        Production[] productionArray = this.grammarView.getSelected();
        for (int i = 0; i < productionArray.length; ++i) {
            if (this.alreadyDone.contains(productionArray[i])) continue;
            Transition transition = (Transition)this.pToT.get(productionArray[i]);
            this.automaton.addTransition(transition);
        }
    }

    public boolean isDone() {
        int n = this.pToT.size() - this.alreadyDone.size();
        String string = n == 0 ? "The conversion is finished!" : n + " more transition" + (n == 1 ? "" : "s") + " must be added.";
        JOptionPane.showMessageDialog(this.parent, string);
        return n == 0;
    }

    public void export() {
        boolean bl;
        boolean bl2 = bl = this.pToT.size() - this.alreadyDone.size() == 0;
        if (!bl) {
            JOptionPane.showMessageDialog(this.parent, "The conversion is not completed yet!");
            return;
        }
        Automaton automaton = (Automaton)this.automaton.clone();
        FrameFactory.createFrame(automaton);
    }
}

