/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.automata;

import automata.State;
import automata.Transition;
import automata.fsa.FSAToRegularGrammarConverter;
import automata.fsa.FiniteStateAutomaton;
import grammar.Grammar;
import grammar.Production;
import grammar.reg.RegularGrammar;
import gui.grammar.automata.ConvertController;
import gui.grammar.automata.ConvertPane;
import gui.viewer.SelectionDrawer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class FSAConvertController
extends ConvertController {
    private FSAToRegularGrammarConverter converter = new FSAToRegularGrammarConverter();

    public FSAConvertController(ConvertPane convertPane, SelectionDrawer selectionDrawer, FiniteStateAutomaton finiteStateAutomaton) {
        super(convertPane, selectionDrawer, finiteStateAutomaton);
        this.converter.initializeConverter(finiteStateAutomaton);
        this.fillMap();
        State[] stateArray = finiteStateAutomaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            stateArray[i].setLabel(this.converter.variableForState(stateArray[i]));
        }
    }

    @Override
    protected Production[] getProductions(State state) {
        if (!this.getAutomaton().isFinalState(state)) {
            return new Production[0];
        }
        Production[] productionArray = new Production[]{this.converter.getLambdaProductionForFinalState(this.getAutomaton(), state)};
        return productionArray;
    }

    @Override
    protected Production[] getProductions(Transition transition) {
        Production[] productionArray = new Production[]{this.converter.getProductionForTransition(transition)};
        return productionArray;
    }

    @Override
    protected Grammar getGrammar() {
        int n = this.getModel().getRowCount();
        RegularGrammar regularGrammar = new RegularGrammar();
        regularGrammar.setStartVariable("S");
        ArrayList<Production> arrayList = new ArrayList<Production>();
        for (int i = 0; i < n; ++i) {
            Production production = this.getModel().getProduction(i);
            if (production == null) continue;
            arrayList.add(production);
        }
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                Production production = (Production)object;
                Production production2 = (Production)object2;
                if ("S".equals(production.getLHS())) {
                    if (production.getLHS().equals(production2.getLHS())) {
                        return 0;
                    }
                    return -1;
                }
                if ("S".equals(production2.getLHS())) {
                    return 1;
                }
                return production.getLHS().compareTo(production2.getRHS());
            }

            @Override
            public boolean equals(Object object) {
                return false;
            }
        });
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            regularGrammar.addProduction((Production)iterator.next());
        }
        return regularGrammar;
    }
}

