/*
 * Decompiled with CFR 0.152.
 */
package gui.grammar.automata;

import automata.Automaton;
import automata.State;
import automata.Transition;
import grammar.Grammar;
import grammar.Production;
import gui.environment.FrameFactory;
import gui.grammar.GrammarTable;
import gui.grammar.GrammarTableModel;
import gui.grammar.automata.ConvertPane;
import gui.grammar.automata.GrammarCreationException;
import gui.viewer.SelectionDrawer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class ConvertController {
    protected HashMap objectToProduction = new HashMap();
    protected HashMap productionToObject = new HashMap();
    protected HashSet alreadyDone = new HashSet();
    protected ConvertPane convertPane;
    private Automaton automaton;
    private SelectionDrawer drawer;
    private GrammarTable table;

    public ConvertController(ConvertPane convertPane, SelectionDrawer selectionDrawer, Automaton automaton) {
        this.convertPane = convertPane;
        this.automaton = automaton;
        this.table = convertPane.getTable();
        this.drawer = selectionDrawer;
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ConvertController.this.changeSelection();
            }
        });
    }

    protected void changeSelection() {
        int n;
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        this.drawer.clearSelected();
        if (n == -1) {
            this.convertPane.getAutomatonPane().repaint();
            return;
        }
        for (n = listSelectionModel.getMinSelectionIndex(); n <= n2; ++n) {
            Production production;
            Object v;
            if (!listSelectionModel.isSelectedIndex(n) || (v = this.productionToObject.get(production = this.table.getGrammarModel().getProduction(n))) == null) continue;
            if (v instanceof State) {
                this.drawer.addSelected((State)v);
                continue;
            }
            this.drawer.addSelected((Transition)v);
        }
        this.convertPane.getAutomatonPane().repaint();
    }

    protected void fillMap() {
        State[] stateArray = this.automaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            Production[] productionArray = this.getProductions(stateArray[i]);
            if (productionArray.length == 0) continue;
            this.objectToProduction.put(stateArray[i], productionArray);
            for (int j = 0; j < productionArray.length; ++j) {
                this.productionToObject.put(productionArray[j], stateArray[i]);
            }
        }
        Transition[] transitionArray = this.automaton.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            Production[] productionArray = this.getProductions(transitionArray[i]);
            if (productionArray.length == 0) continue;
            this.objectToProduction.put(transitionArray[i], productionArray);
            for (int j = 0; j < productionArray.length; ++j) {
                this.productionToObject.put(productionArray[j], transitionArray[i]);
            }
        }
    }

    private void addProductions(Collection collection) {
        Iterator iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return;
        }
        GrammarTableModel grammarTableModel = this.table.getGrammarModel();
        int n = 1000000000;
        int n2 = 0;
        while (iterator.hasNext()) {
            Production production = (Production)iterator.next();
            int n3 = grammarTableModel.addProduction(production);
            n = Math.min(n, n3);
            n2 = Math.max(n2, n3);
        }
        this.table.setRowSelectionInterval(n, n2);
    }

    public Production[] revealObjectProductions(Object object) {
        Production[] productionArray = (Production[])this.objectToProduction.get(object);
        if (productionArray == null || productionArray.length == 0) {
            JOptionPane.showMessageDialog(this.convertPane, "There are no productions for that object!");
            return null;
        }
        if (this.alreadyDone.contains(object)) {
            JOptionPane.showMessageDialog(this.convertPane, "This object has already been converted!");
            return new Production[0];
        }
        this.alreadyDone.add(object);
        this.addProductions(Arrays.asList(productionArray));
        return productionArray;
    }

    public Object revealRandomProductions() {
        for (Map.Entry entry : this.objectToProduction.entrySet()) {
            Object k = entry.getKey();
            if (this.alreadyDone.contains(k)) continue;
            Production[] productionArray = (Production[])this.objectToProduction.get(k);
            this.addProductions(Arrays.asList(productionArray));
            this.alreadyDone.add(entry.getKey());
            return k;
        }
        return null;
    }

    public int revealAllProductions() {
        HashSet hashSet = new HashSet(this.objectToProduction.keySet());
        hashSet.removeAll(this.alreadyDone);
        int n = hashSet.size();
        Iterator iterator = hashSet.iterator();
        ArrayList<Production> arrayList = new ArrayList<Production>();
        while (iterator.hasNext()) {
            Production[] productionArray = (Production[])this.objectToProduction.get(iterator.next());
            arrayList.addAll(Arrays.asList(productionArray));
        }
        this.addProductions(arrayList);
        this.alreadyDone.addAll(hashSet);
        return n;
    }

    public Object[] highlightUntransformed() {
        HashSet hashSet = new HashSet(this.objectToProduction.keySet());
        hashSet.removeAll(this.alreadyDone);
        Object[] objectArray = hashSet.toArray();
        this.drawer.clearSelected();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof State) {
                this.drawer.addSelected((State)objectArray[i]);
                continue;
            }
            this.drawer.addSelected((Transition)objectArray[i]);
        }
        this.convertPane.getAutomatonPane().repaint();
        return objectArray;
    }

    protected abstract Grammar getGrammar();

    public Grammar exportGrammar() {
        if (this.objectToProduction.keySet().size() != this.alreadyDone.size()) {
            this.highlightUntransformed();
            JOptionPane.showMessageDialog(this.convertPane, "Conversion unfinished!  Objects to convert are highlighted.", "Conversion Unfinished", 0);
            this.changeSelection();
            return null;
        }
        try {
            Grammar grammar = this.getGrammar();
            FrameFactory.createFrame(grammar);
            return grammar;
        }
        catch (GrammarCreationException grammarCreationException) {
            JOptionPane.showMessageDialog(this.convertPane, grammarCreationException.getMessage(), "Error", 0);
            return null;
        }
    }

    protected Automaton getAutomaton() {
        return this.automaton;
    }

    protected Production[] getProductions(State state) {
        return new Production[0];
    }

    protected Production[] getProductions(Transition transition) {
        return new Production[0];
    }

    protected GrammarTableModel getModel() {
        return this.table.getGrammarModel();
    }
}

