/*
 * Decompiled with CFR 0.152.
 */
package gui.environment;

import file.xml.DOMPrettier;
import gui.editor.TMTransitionCreator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Profile {
    public static String LAMBDA = "\u03bb";
    public static String EPSILON = "\u03b5";
    public String lambda = "\u03bb";
    public String epsilon = "\u03b5";
    public String lambdaText = "u03BB";
    public String epsilonText = "u03B5";
    private String emptyString = this.lambda;
    public int undo_num = 50;
    public String EMPTY_STRING_NAME = "empty_string";
    public static final String STRUCTURE_NAME = "structure";
    public static final String STRUCTURE_TYPE_NAME = "type";
    public static final String TURING_FINAL_NAME = "turing_final";
    public static final String UNDO_AMOUNT_NAME = "undo_amount";
    public static final String ACCEPT_FINAL_STATE = "turing_accept_by_final_state";
    public static final String ACCEPT_HALT = "turing_accept_by_halt";
    public static final String ALLOW_STAY = "turing_allow_stay_on_transition";
    private boolean transTuringFinal = false;
    private boolean turingAcceptByFinalState;
    private boolean turingAcceptByHalting;
    private boolean turingAllowStay;
    private JCheckBoxMenuItem transTuringFinalCheckBox = new JCheckBoxMenuItem("Enable Transitions From Turing Machine Final States");
    private JCheckBoxMenuItem turingAcceptByFinalStateCheckBox;
    private JCheckBoxMenuItem turingAcceptByHaltingCheckBox;
    private JCheckBoxMenuItem turingAllowStayCheckBox;
    public String pathToFile = "";

    public void setNumUndo(int n) {
        this.undo_num = n;
    }

    public Profile() {
        this.transTuringFinalCheckBox.setSelected(this.transTuringFinal);
        this.transTuringFinalCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Profile.this.setTransitionsFromTuringFinalStateAllowed(Profile.this.transTuringFinalCheckBox.isSelected());
                Profile.this.savePreferences();
            }
        });
        this.turingAcceptByFinalState = true;
        this.turingAcceptByFinalStateCheckBox = new JCheckBoxMenuItem("Accept by Final State");
        this.turingAcceptByFinalStateCheckBox.setSelected(this.turingAcceptByFinalState);
        this.turingAcceptByFinalStateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Profile.this.setAcceptByFinalState(Profile.this.turingAcceptByFinalStateCheckBox.isSelected());
                Profile.this.savePreferences();
            }
        });
        this.turingAcceptByHalting = false;
        this.turingAcceptByHaltingCheckBox = new JCheckBoxMenuItem("Accept by Halting");
        this.turingAcceptByHaltingCheckBox.setSelected(this.turingAcceptByHalting);
        this.turingAcceptByHaltingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Profile.this.setAcceptByHalting(Profile.this.turingAcceptByHaltingCheckBox.isSelected());
                Profile.this.savePreferences();
            }
        });
        this.turingAllowStay = false;
        this.turingAllowStayCheckBox = new JCheckBoxMenuItem("Allow stay for tape head on transition");
        this.turingAllowStayCheckBox.setSelected(this.turingAllowStay);
        this.turingAllowStayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Profile.this.setAllowStay(Profile.this.turingAllowStayCheckBox.isSelected());
                Profile.this.savePreferences();
            }
        });
    }

    public void setEmptyString(String string) {
        this.emptyString = string;
    }

    public String getEmptyString() {
        return this.emptyString;
    }

    public void setTransitionsFromTuringFinalStateAllowed(boolean bl) {
        this.transTuringFinal = bl;
        this.transTuringFinalCheckBox.setSelected(bl);
    }

    public void setAcceptByFinalState(boolean bl) {
        this.turingAcceptByFinalState = bl;
        this.turingAcceptByFinalStateCheckBox.setSelected(bl);
    }

    public void setAcceptByHalting(boolean bl) {
        this.turingAcceptByHalting = bl;
        this.turingAcceptByHaltingCheckBox.setSelected(bl);
    }

    public void setAllowStay(boolean bl) {
        this.turingAllowStay = bl;
        this.turingAllowStayCheckBox.setSelected(bl);
        TMTransitionCreator.setDirs(bl);
    }

    public boolean transitionsFromTuringFinalStateAllowed() {
        return this.transTuringFinal;
    }

    public boolean getAcceptByFinalState() {
        return this.turingAcceptByFinalState;
    }

    public boolean getAcceptByHalting() {
        return this.turingAcceptByHalting;
    }

    public JCheckBoxMenuItem getTuringFinalCheckBox() {
        return this.transTuringFinalCheckBox;
    }

    public JCheckBoxMenuItem getAcceptByFinalStateCheckBox() {
        return this.turingAcceptByFinalStateCheckBox;
    }

    public JCheckBoxMenuItem getAcceptByHaltingCheckBox() {
        return this.turingAcceptByHaltingCheckBox;
    }

    public JCheckBoxMenuItem getAllowStayCheckBox() {
        return this.turingAllowStayCheckBox;
    }

    public void savePreferences() {
        String string = "";
        if (this.emptyString.equals(this.lambda)) {
            string = this.lambdaText;
        } else if (this.emptyString.equals(this.epsilon)) {
            string = this.epsilonText;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            File file = new File(this.pathToFile);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.appendChild(document.createComment("Created with JFLAP 6.4."));
            Element element = Profile.createElement(document, STRUCTURE_NAME, null, null);
            document.appendChild(element);
            Element element2 = document.getDocumentElement();
            Element element3 = Profile.createElement(document, this.EMPTY_STRING_NAME, null, "" + string);
            element2.appendChild(element3);
            element3 = Profile.createElement(document, TURING_FINAL_NAME, null, "" + this.transTuringFinal);
            element2.appendChild(element3);
            element3 = Profile.createElement(document, UNDO_AMOUNT_NAME, null, "" + this.undo_num);
            element2.appendChild(element3);
            element3 = Profile.createElement(document, ACCEPT_FINAL_STATE, null, "" + this.turingAcceptByFinalState);
            element2.appendChild(element3);
            element3 = Profile.createElement(document, ACCEPT_HALT, null, "" + this.turingAcceptByHalting);
            element2.appendChild(element3);
            element3 = Profile.createElement(document, ALLOW_STAY, null, "" + this.turingAllowStay);
            element2.appendChild(element3);
            DOMPrettier.makePretty(document);
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(file);
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                try {
                    transformer.transform(dOMSource, streamResult);
                }
                catch (TransformerException transformerException) {
                    transformerException.printStackTrace();
                }
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                transformerConfigurationException.printStackTrace();
            }
            catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
                transformerFactoryConfigurationError.printStackTrace();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    protected static Element createElement(Document document, String string, Map map, String string2) {
        Element element = document.createElement(string);
        if (string2 != null) {
            element.appendChild(document.createTextNode(string2));
        }
        return element;
    }
}

