/*
 * Decompiled with CFR 0.152.
 */
package gui.environment;

import file.Codec;
import file.EncodeException;
import file.ParseException;
import gui.editor.EditBlockPane;
import gui.editor.EditorPane;
import gui.environment.Environment;
import gui.environment.FileChangeEvent;
import gui.environment.FileChangeListener;
import gui.environment.Universe;
import gui.grammar.GrammarInputPane;
import gui.menu.MenuBarCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class EnvironmentFrame
extends JFrame {
    private Environment environment;
    private int myNumber = -559038737;
    private static final String DEFAULT_TITLE = "JFLAP";

    public EnvironmentFrame(Environment environment) {
        this.environment = environment;
        environment.addFileChangeListener(new FileChangeListener(){

            @Override
            public void fileChanged(FileChangeEvent fileChangeEvent) {
                EnvironmentFrame.this.refreshTitle();
            }
        });
        this.initMenuBar();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)environment, "Center");
        this.myNumber = Universe.registerFrame(this);
        this.refreshTitle();
        this.addWindowListener(new Listener());
        this.setLocation(50, 50);
        this.setDefaultCloseOperation(0);
        this.resizeWatcher();
    }

    public EnvironmentFrame(Environment environment, int n) {
        this.environment = environment;
        environment.addFileChangeListener(new FileChangeListener(){

            @Override
            public void fileChanged(FileChangeEvent fileChangeEvent) {
                EnvironmentFrame.this.refreshTitle();
            }
        });
        this.setJMenuBar(MenuBarCreator.getMenuBar(this, 0));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)environment, "Center");
        this.myNumber = Universe.registerFrame(this);
        this.refreshTitle();
        this.addWindowListener(new Listener());
        this.setLocation(50, 50);
        this.setDefaultCloseOperation(0);
        this.resizeWatcher();
    }

    public String getDescription() {
        if (this.environment.getFile() == null) {
            return "<untitled" + this.myNumber + ">";
        }
        if (this.environment.myObjects != null && this.environment.getActive() != null && (this.environment.getActive() instanceof EditorPane || this.environment.getActive() instanceof GrammarInputPane)) {
            return this.environment.getActive().getName();
        }
        return "(" + this.environment.getFile().getName() + ")";
    }

    protected void refreshTitle() {
        String string = "JFLAP : " + this.getDescription();
        this.setTitle(string);
    }

    protected void initMenuBar() {
        this.setJMenuBar(MenuBarCreator.getMenuBar(this));
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public boolean save(boolean bl) {
        String string;
        String string2;
        Serializable serializable;
        JComponent jComponent;
        Serializable serializable2 = bl ? null : this.environment.getFile();
        Codec codec = (Codec)this.environment.getEncoder();
        Serializable serializable3 = this.environment.getObject();
        if (this.environment.myObjects != null && this.environment.getActive() != null && this.environment.getActive() instanceof EditorPane) {
            jComponent = (EditorPane)this.environment.getActive();
            serializable = new File(((EditorPane)jComponent).getAutomaton().getFilePath() + ((EditorPane)jComponent).getAutomaton().getFileName());
            serializable2 = bl ? null : serializable;
            serializable3 = ((EditorPane)jComponent).getAutomaton();
        } else if (this.environment.myObjects != null && this.environment.getActive() != null && this.environment.getActive() instanceof GrammarInputPane) {
            jComponent = (GrammarInputPane)this.environment.getActive();
            serializable = new File(((GrammarInputPane)jComponent).getGrammar().getFilePath() + ((GrammarInputPane)jComponent).getGrammar().getFileName());
            serializable2 = bl ? null : serializable;
            serializable3 = ((GrammarInputPane)jComponent).getGrammar();
        }
        boolean bl2 = false;
        if (this.environment.getActive() instanceof EditBlockPane) {
            serializable = (EditBlockPane)this.environment.getActive();
            serializable3 = ((EditorPane)serializable).getAutomaton();
            bl2 = true;
        }
        boolean bl3 = false;
        if (!(serializable2 == null || codec != null && codec.canEncode(serializable3))) {
            JOptionPane.showMessageDialog(this, "We cannot write this structure in the same format\nit was read as!  Use Save As to select a new format.", "IO Error", 0);
            return false;
        }
        FileFilter[] fileFilterArray = Universe.CHOOSER.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            Universe.CHOOSER.removeChoosableFileFilter(fileFilterArray[i]);
        }
        List list = Universe.CODEC_REGISTRY.getEncoders(serializable3);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Universe.CHOOSER.addChoosableFileFilter((FileFilter)iterator.next());
        }
        if (codec != null && codec.canEncode(serializable3)) {
            Universe.CHOOSER.setFileFilter(codec);
        } else {
            Universe.CHOOSER.setFileFilter((FileFilter)list.get(0));
        }
        if (bl) {
            Universe.CHOOSER.setDialogTitle("Save As");
        }
        if (serializable2 != null && codec != null && !(string2 = ((File)serializable2).getName()).equals(string = codec.proposeFilename(string2, serializable3))) {
            int n = JOptionPane.showConfirmDialog(this, "To save as a " + codec.getDescription() + ",\n" + "JFLAP wants to save " + string2 + " to a new file\n" + "named " + string + ".  Is that OK?");
            switch (n) {
                case 2: {
                    return false;
                }
                case 1: {
                    break;
                }
                case 0: {
                    serializable2 = new File(((File)serializable2).getParent(), string);
                    bl3 = true;
                }
            }
        }
        block14: while (bl3 || serializable2 == null) {
            if (!bl3) {
                int n = Universe.CHOOSER.showSaveDialog(this);
                if (n != 0) {
                    return false;
                }
                serializable2 = Universe.CHOOSER.getSelectedFile();
                if (serializable2 != null) {
                    string = ((File)serializable2).getName();
                    codec = (Codec)Universe.CHOOSER.getFileFilter();
                    serializable2 = new File(Universe.CHOOSER.getCurrentDirectory(), codec.proposeFilename(string, serializable3));
                } else {
                    JOptionPane.showMessageDialog(null, "JFLAP could not determine the selected file name.  Try again.", "Error", 0);
                    serializable2 = null;
                    continue;
                }
            }
            bl3 = false;
            if (!((File)serializable2).exists()) continue;
            int n = JOptionPane.showConfirmDialog(this, "Overwrite " + ((File)serializable2).getName() + "?");
            switch (n) {
                case 2: {
                    return false;
                }
                case 1: {
                    serializable2 = null;
                    continue block14;
                }
            }
        }
        Universe.CHOOSER.resetChoosableFileFilters();
        try {
            codec.encode(serializable3, (File)serializable2, null);
            if (!bl2) {
                this.environment.setFile((File)serializable2);
            }
            this.environment.setEncoder(codec);
            this.environment.clearDirty();
            return true;
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this, parseException.getMessage(), "Write Error", 0);
            return false;
        }
        catch (EncodeException encodeException) {
            JOptionPane.showMessageDialog(this, encodeException.getMessage(), "Write Error", 0);
            return false;
        }
    }

    public boolean close() {
        if (this.environment.isDirty()) {
            File file = this.environment.getFile();
            String string = file == null ? "untitled" : file.getName();
            int n = JOptionPane.showConfirmDialog(this, "Save " + string + " before closing?");
            if (n == 2) {
                return false;
            }
            if (n == 0) {
                this.save(false);
            }
            if (n == -1) {
                return false;
            }
        }
        this.dispose();
        Universe.unregisterFrame(this);
        return true;
    }

    public void resizeWatcher() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                EnvironmentFrame.this.environment.resizeSplit();
            }
        });
    }

    @Override
    public String toString() {
        return this.getDescription();
    }

    private class Listener
    extends WindowAdapter {
        private Listener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            EnvironmentFrame.this.close();
        }
    }
}

