/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import gui.editor.DeleteTool;
import gui.editor.EditCanvas;
import gui.editor.Tool;
import gui.editor.ToolAdapter;
import gui.editor.ToolBox;
import gui.viewer.AutomatonDrawer;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class ToolBar
extends JToolBar
implements ActionListener {
    private Component view;
    private AutomatonDrawer drawer;
    private List tools;
    private HashMap buttonsToTools = new HashMap();
    private ToolAdapter adapter;
    private Tool currentTool = null;

    public ToolBar(EditCanvas editCanvas, AutomatonDrawer automatonDrawer, ToolBox toolBox) {
        this.adapter = new ToolAdapter(editCanvas);
        this.view = editCanvas;
        this.drawer = automatonDrawer;
        this.tools = toolBox.tools(editCanvas, automatonDrawer);
        this.initBar();
        editCanvas.addMouseListener(this.adapter);
        editCanvas.addMouseMotionListener(this.adapter);
    }

    protected Component getView() {
        return this.view;
    }

    protected AutomatonDrawer getDrawer() {
        return this.drawer;
    }

    private void initBar() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JToggleButton jToggleButton = null;
        for (Tool tool : this.tools) {
            jToggleButton = new JToggleButton(tool.getIcon());
            this.buttonsToTools.put(jToggleButton, tool);
            jToggleButton.setToolTipText(tool.getShortcutToolTip());
            buttonGroup.add(jToggleButton);
            this.add(jToggleButton);
            jToggleButton.addActionListener(this);
            KeyStroke keyStroke = tool.getKey();
            if (keyStroke == null) continue;
            InputMap inputMap = jToggleButton.getInputMap(2);
            ActionMap actionMap = jToggleButton.getActionMap();
            Object object = new Object();
            inputMap.put(keyStroke, object);
            actionMap.put(object, new ButtonClicker(jToggleButton));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Tool tool = (Tool)this.buttonsToTools.get(actionEvent.getSource());
        if (tool != null) {
            this.adapter.setAdapter(tool);
            this.currentTool = tool;
            this.view.setCursor(new Cursor(0));
        }
        if (tool instanceof DeleteTool) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            URL uRL = this.getClass().getResource("/ICON/deletecursor.gif");
            Image image = this.getToolkit().getImage(uRL);
            Point point = new Point(5, 5);
            Cursor cursor = toolkit.createCustomCursor(image, point, "Delete");
            this.view.setCursor(cursor);
        }
    }

    public void drawTool(Graphics graphics) {
        if (this.currentTool == null) {
            return;
        }
        this.currentTool.draw(graphics);
    }

    public Tool getCurrentTool() {
        return this.currentTool;
    }

    private class ButtonClicker
    extends AbstractAction {
        AbstractButton button;

        public ButtonClicker(AbstractButton abstractButton) {
            this.button = abstractButton;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.button.doClick();
        }
    }
}

