/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.Automaton;
import gui.SuperMouseAdapter;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.Graphics;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public abstract class Tool
extends SuperMouseAdapter {
    private AutomatonPane view;
    private AutomatonDrawer drawer;
    private Automaton automaton;

    public Tool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
        this.view = automatonPane;
        this.drawer = automatonDrawer;
        this.automaton = automatonDrawer.getAutomaton();
    }

    public String getShortcutToolTip() {
        String string = this.getToolTip();
        KeyStroke keyStroke = this.getKey();
        if (keyStroke == null) {
            return string;
        }
        int n = Tool.findDominant(string, keyStroke.getKeyChar());
        if (n == -1) {
            return string + "(" + Character.toUpperCase(keyStroke.getKeyChar()) + ")";
        }
        return string.substring(0, n) + "(" + string.substring(n, n + 1) + ")" + string.substring(n + 1, string.length());
    }

    public String getToolTip() {
        return "Tool";
    }

    protected AutomatonPane getView() {
        return this.view;
    }

    protected AutomatonDrawer getDrawer() {
        return this.drawer;
    }

    protected Icon getIcon() {
        URL uRL = this.getClass().getResource("/ICON/default.gif");
        return new ImageIcon(uRL);
    }

    public void draw(Graphics graphics) {
    }

    protected Automaton getAutomaton() {
        return this.automaton;
    }

    public KeyStroke getKey() {
        return null;
    }

    protected static int findDominant(String string, char c) {
        int n = string.indexOf(Character.toUpperCase(c));
        if (n != -1) {
            return n;
        }
        return string.indexOf(Character.toLowerCase(c));
    }
}

