/*
 * Decompiled with CFR 0.152.
 */
package gui.editor;

import automata.State;
import gui.editor.TMTransitionCreator;
import gui.editor.TransitionCreator;
import gui.editor.TransitionTool;
import gui.viewer.AutomatonDrawer;
import gui.viewer.AutomatonPane;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

public class BlockTransitionTool
extends TransitionTool {
    public BlockTransitionTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer, TransitionCreator transitionCreator) {
        super(automatonPane, automatonDrawer);
        this.creator = transitionCreator;
    }

    @Override
    public KeyStroke getKey() {
        return KeyStroke.getKeyStroke('T');
    }

    public BlockTransitionTool(AutomatonPane automatonPane, AutomatonDrawer automatonDrawer) {
        super(automatonPane, automatonDrawer);
        this.creator = TransitionCreator.creatorForAutomaton(this.getAutomaton(), this.getView());
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.first == null) {
            return;
        }
        State state = this.getDrawer().stateAtPoint(mouseEvent.getPoint());
        if (state != null && this.creator instanceof TMTransitionCreator) {
            TMTransitionCreator tMTransitionCreator = (TMTransitionCreator)this.creator;
            tMTransitionCreator.setBlockTransition(true);
            tMTransitionCreator.createTransition(this.first, state);
        }
        this.first = null;
        this.getView().repaint();
    }

    @Override
    public String getToolTip() {
        return "BlockTransition Creator";
    }

    @Override
    protected Icon getIcon() {
        URL uRL = this.getClass().getResource("/ICON/blockTransition.gif");
        return new ImageIcon(uRL);
    }
}

