/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.fsa.FiniteStateAutomaton;
import automata.pda.PushdownAutomaton;
import automata.turing.TuringMachine;
import file.Codec;
import file.DataException;
import file.ParseException;
import grammar.Grammar;
import gui.action.BatchMultipleSimulateAction;
import gui.action.MultipleOutputSimulateAction;
import gui.action.MultipleSimulateAction;
import gui.action.OpenAction;
import gui.action.RestrictedAction;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.FrameFactory;
import gui.environment.Universe;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class TestAction
extends RestrictedAction {
    private JFileChooser fileChooser;
    public static ArrayList myObjects = new ArrayList();
    public static EnvironmentFrame myEnvFrame;

    public TestAction() {
        super("Batch Test", null);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, MAIN_MENU_MASK));
        this.fileChooser = Universe.CHOOSER;
    }

    public TestAction(String string, int n) {
        super(string, null);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(n, MAIN_MENU_MASK));
        this.fileChooser = Universe.CHOOSER;
    }

    public ArrayList chooseFile(Component component, boolean bl) {
        File file = this.fileChooser.getCurrentDirectory();
        this.fileChooser.setCurrentDirectory(file.getParentFile());
        this.fileChooser.setCurrentDirectory(file);
        this.fileChooser.rescanCurrentDirectory();
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setDialogTitle("Choose Files Of The Same Type To Test");
        Codec[] codecArray = null;
        codecArray = OpenAction.makeFilters();
        int n = this.fileChooser.showOpenDialog(component);
        if (n != 0) {
            return null;
        }
        File[] fileArray = this.fileChooser.getSelectedFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.getAbsolutePath().endsWith(".jff")) {
                JOptionPane.showMessageDialog(component, "One of the files does not end in .jff", "Read Error", 0);
                return null;
            }
            try {
                if (i == 0) {
                    TestAction.openFile(file2, codecArray, bl);
                    continue;
                }
                TestAction.openFile(file2, codecArray, false);
                continue;
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(component, parseException.getMessage(), "Read Error", 0);
                continue;
            }
            catch (DataException dataException) {
                JOptionPane.showMessageDialog(component, dataException.getMessage(), "Data Error", 0);
            }
        }
        if (fileArray == null) {
            return null;
        }
        myEnvFrame.getEnvironment().setMultipleObjects(myObjects);
        return myObjects;
    }

    public boolean checkRightType(Environment environment, Component component) {
        if (environment.myObjects.size() == 0) {
            return false;
        }
        Object e = environment.myObjects.get(0);
        int n = this.findType(e);
        for (int i = 0; i < environment.myObjects.size(); ++i) {
            int n2 = this.findType(environment.myObjects.get(i));
            if (n2 == 0) {
                JOptionPane.showMessageDialog(component, "This feature only works with Finite Automata, Pushdown Automata, and Turing Machines", "Error", 0);
                return false;
            }
            if (n == n2) continue;
            JOptionPane.showMessageDialog(component, "Files Must Be The Same Type", "Error", 0);
            return false;
        }
        return true;
    }

    public void performAction(Component component) {
        ArrayList arrayList = null;
        boolean bl = false;
        while (arrayList == null || !bl) {
            if (myEnvFrame != null) {
                TestAction.myEnvFrame.getEnvironment().myObjects.clear();
            }
            arrayList = this.chooseFile(component, true);
            try {
                bl = this.checkRightType(myEnvFrame.getEnvironment(), component);
            }
            catch (NullPointerException nullPointerException) {
                return;
            }
            if (arrayList != null) continue;
            return;
        }
        this.fileChooser.setDialogTitle("Choose file of strings to test on machines");
        this.fileChooser.setFileFilter(new inputFilter());
        int n = this.fileChooser.showOpenDialog(component);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (n == 0) {
            File file = this.fileChooser.getSelectedFile();
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                Object e = TestAction.myEnvFrame.getEnvironment().myObjects.get(0);
                int n2 = 1;
                if (e instanceof TuringMachine) {
                    TuringMachine turingMachine = (TuringMachine)e;
                    n2 = turingMachine.tapes;
                }
                boolean bl2 = false;
                while ((string = bufferedReader.readLine()) != null) {
                    bl2 = false;
                    if (string.equals("")) continue;
                    String[] stringArray = string.split(" ");
                    for (int i = 0; i < n2; ++i) {
                        arrayList2.add(stringArray[i]);
                        if (stringArray[stringArray.length - 1].toLowerCase().equals("reject")) {
                            bl2 = true;
                            arrayList3.add("~");
                            continue;
                        }
                        if (stringArray.length > i + 1 + n2) {
                            arrayList3.add(stringArray[i + n2]);
                            continue;
                        }
                        arrayList3.add("~");
                    }
                    if (bl2 && arrayList3.size() > 0) {
                        arrayList3.add("reject");
                        continue;
                    }
                    arrayList3.add("accept");
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        TestAction.myEnvFrame.getEnvironment().myTestStrings = arrayList2;
        TestAction.myEnvFrame.getEnvironment().myTransducerStrings = arrayList3;
        this.displayMultipleRunPane(myEnvFrame.getEnvironment(), myObjects.get(0));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Component component = null;
        try {
            component = (Component)actionEvent.getSource();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.performAction(component);
    }

    private int findType(Object object) {
        int n = 0;
        if (object instanceof TuringMachine) {
            n = 1;
        } else if (object instanceof PushdownAutomaton) {
            n = 2;
        } else if (object instanceof FiniteStateAutomaton) {
            n = 3;
        } else if (object instanceof Grammar) {
            n = 4;
        }
        return n;
    }

    protected void displayMultipleRunPane(Environment environment, Object object) {
        if (object instanceof FiniteStateAutomaton) {
            BatchMultipleSimulateAction batchMultipleSimulateAction = new BatchMultipleSimulateAction((Automaton)object, environment);
            batchMultipleSimulateAction.performAction(environment);
        } else if (object instanceof TuringMachine) {
            MultipleOutputSimulateAction multipleOutputSimulateAction = new MultipleOutputSimulateAction((Automaton)object, environment);
            multipleOutputSimulateAction.performAction(environment);
        } else if (object instanceof PushdownAutomaton) {
            MultipleSimulateAction multipleSimulateAction = new MultipleSimulateAction((Automaton)object, environment);
            multipleSimulateAction.performAction(environment);
        } else if (object instanceof Grammar) {
            MultipleSimulateAction multipleSimulateAction = new MultipleSimulateAction((Grammar)object, environment);
            multipleSimulateAction.performAction(environment);
        }
    }

    public static Environment openFile(File file, Codec[] codecArray, boolean bl) {
        ParseException parseException = null;
        int n = 0;
        if (n < codecArray.length) {
            try {
                Cloneable cloneable;
                Serializable serializable = codecArray[n].decode(file, null);
                if (serializable instanceof Automaton) {
                    cloneable = (Automaton)serializable;
                    try {
                        ((Automaton)cloneable).setFilePath(file.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (serializable instanceof Grammar) {
                    try {
                        cloneable = (Grammar)serializable;
                        ((Grammar)cloneable).setFilePath(file.getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                myObjects.add(serializable);
                if (bl) {
                    myEnvFrame = FrameFactory.createFrame(serializable);
                    if (myEnvFrame == null) {
                        return null;
                    }
                    myEnvFrame.getEnvironment().setFile(file);
                    myEnvFrame.getEnvironment().setEncoder(codecArray[n].correspondingEncoder());
                    return myEnvFrame.getEnvironment();
                }
                if (serializable instanceof Automaton) {
                    ((Automaton)serializable).setEnvironmentFrame(myEnvFrame);
                } else if (serializable instanceof Grammar) {
                    ((Grammar)serializable).setEnvironmentFrame(myEnvFrame);
                }
            }
            catch (ParseException parseException2) {
                parseException = parseException2;
            }
            return null;
        }
        if (codecArray.length != 1) {
            parseException = new ParseException("No format could read the file!");
        }
        throw parseException;
    }

    class inputFilter
    extends FileFilter {
        inputFilter() {
        }

        @Override
        public boolean accept(File file) {
            String string = file.getName();
            return string.endsWith(".txt");
        }

        @Override
        public String getDescription() {
            return "*.txt";
        }
    }
}

