/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.NondeterminismDetector;
import automata.NondeterminismDetectorFactory;
import automata.SimulatorFactory;
import automata.State;
import automata.graph.AutomatonDirectedGraph;
import automata.mealy.MealyMachine;
import automata.turing.TMSimulator;
import automata.turing.TuringMachine;
import grammar.Grammar;
import gui.action.AutomatonAction;
import gui.action.SimulateNoClosureAction;
import gui.editor.EditBlockPane;
import gui.editor.EditorPane;
import gui.environment.Environment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.sim.SimulatorPane;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Scanner;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class SimulateAction
extends AutomatonAction {
    private Grammar gram;
    private Automaton automaton;
    private Environment environment;

    public SimulateAction(Automaton automaton, Environment environment) {
        super("Step...", null);
        if (SimulateNoClosureAction.isApplicable(automaton)) {
            this.putValue("Name", "Step with Closure...");
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, MAIN_MENU_MASK));
        this.automaton = automaton;
        this.environment = environment;
    }

    public SimulateAction(Grammar grammar, Environment environment) {
        super("Step...", null);
        if (SimulateNoClosureAction.isApplicable(this.automaton)) {
            this.putValue("Name", "Step with Closure...");
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, MAIN_MENU_MASK));
        this.gram = grammar;
        this.environment = environment;
    }

    protected AutomatonSimulator getSimulator(Automaton automaton) {
        return SimulatorFactory.getSimulator(automaton);
    }

    public void handleInteraction(Automaton automaton, AutomatonSimulator automatonSimulator, Configuration[] configurationArray, Object list) {
        SimulatorPane simulatorPane = new SimulatorPane(automaton, automatonSimulator, configurationArray, this.environment, false);
        if (list instanceof String[]) {
            list = Arrays.asList((String[])list);
        }
        this.environment.add((Component)simulatorPane, "Simulate: " + list, new CriticalTag(){});
        this.environment.setActive(simulatorPane);
    }

    protected Object initialInput(Component component, String string) {
        if (string.equals("")) {
            string = "Input";
        }
        if (this.getObject() instanceof TuringMachine) {
            TuringMachine turingMachine = (TuringMachine)this.getObject();
            int n = turingMachine.tapes();
            if (string.equals("Expected Result? (Accept or Reject)")) {
                string = "Result";
                n = 1;
            }
            if (string.equals("Expected Output?")) {
                string = "Output";
            }
            return this.openInputGUI(component, string, n);
        }
        if (string.equals("")) {
            return this.openInputGUI(component, "Input?", 0);
        }
        return this.openInputGUI(component, string, 0);
    }

    private Object openInputGUI(final Component component, String string, final int n) {
        int n2;
        JTextField[] jTextFieldArray;
        JPanel jPanel;
        if (n == 0) {
            jPanel = new JPanel(new GridLayout(3, 1));
            jTextFieldArray = new JTextField[1];
            for (n2 = 0; n2 < 1; ++n2) {
                jPanel.add(new JLabel(string + " "));
                jTextFieldArray[n2] = new JTextField();
                jPanel.add(jTextFieldArray[n2]);
            }
        } else {
            jPanel = new JPanel(new GridLayout(n * 2 + 1, 2));
            jTextFieldArray = new JTextField[n];
            for (n2 = 0; n2 < n; ++n2) {
                jPanel.add(new JLabel(string + " " + (n2 + 1)));
                jTextFieldArray[n2] = new JTextField();
                jPanel.add(jTextFieldArray[n2]);
            }
        }
        JButton jButton = new JButton("Click to Open Input File");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(System.getProperties().getProperty("user.dir"));
                int n2 = jFileChooser.showOpenDialog(null);
                File file = null;
                if (n2 == 0) {
                    file = jFileChooser.getSelectedFile();
                    try {
                        Scanner scanner = new Scanner(file);
                        if (n != 0) {
                            String[] stringArray = new String[n];
                            for (int i = 0; i < n; ++i) {
                                if (!scanner.hasNext()) {
                                    JOptionPane.showMessageDialog(component, "Input file does not have enough input for all tapes", "File read error", 0);
                                    return;
                                }
                                stringArray[i] = scanner.next();
                            }
                            JOptionPane.getFrameForComponent(component).dispose();
                            SimulateAction.this.handleInputFile(stringArray);
                        } else {
                            String string = scanner.next();
                            JOptionPane.getFrameForComponent(component).dispose();
                            SimulateAction.this.handleInputFile(string);
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                }
            }
        });
        jPanel.add(jButton);
        int n3 = JOptionPane.showOptionDialog(component, jPanel, string, 2, 3, null, null, null);
        if (n3 != 0 && n3 != 0) {
            return null;
        }
        if (n == 0) {
            String string2 = jTextFieldArray[0].getText();
            return string2;
        }
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = jTextFieldArray[i].getText();
        }
        return stringArray;
    }

    private void handleInputFile(Object object) {
        Configuration[] configurationArray = null;
        AutomatonSimulator automatonSimulator = this.getSimulator(this.automaton);
        if (object == null) {
            return;
        }
        if (this.getObject() instanceof TuringMachine) {
            String[] stringArray = (String[])object;
            configurationArray = ((TMSimulator)automatonSimulator).getInitialConfigurations(stringArray);
        } else {
            String string = (String)object;
            configurationArray = automatonSimulator.getInitialConfigurations(string);
        }
        this.handleInteraction(this.automaton, automatonSimulator, configurationArray, object);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        boolean bl = false;
        if (this.environment.getActive() instanceof EditBlockPane) {
            object = (EditBlockPane)this.environment.getActive();
            this.automaton = ((EditorPane)object).getAutomaton();
            bl = true;
        }
        if (!this.automatonActionPermissible((Component)actionEvent.getSource())) {
            return;
        }
        object = this.initialInput((Component)actionEvent.getSource(), "");
        Configuration[] configurationArray = null;
        AutomatonSimulator automatonSimulator = this.getSimulator(this.automaton);
        if (object == null) {
            return;
        }
        if (this.getObject() instanceof TuringMachine) {
            String[] stringArray = (String[])object;
            configurationArray = ((TMSimulator)automatonSimulator).getInitialConfigurations(stringArray);
        } else {
            String string = (String)object;
            configurationArray = automatonSimulator.getInitialConfigurations(string);
        }
        this.handleInteraction(this.automaton, automatonSimulator, configurationArray, object);
    }

    protected boolean automatonActionPermissible(Component component) {
        if (!(this.getObject() instanceof Automaton)) {
            return true;
        }
        if (this.automaton.getInitialState() == null) {
            JOptionPane.showMessageDialog(component, "Simulation requires an automaton\nwith an initial state!", "No Initial State", 0);
            return false;
        }
        if (this.automaton instanceof MealyMachine) {
            NondeterminismDetector nondeterminismDetector = NondeterminismDetectorFactory.getDetector(this.automaton);
            State[] stateArray = nondeterminismDetector.getNondeterministicStates(this.automaton);
            if (stateArray.length > 0) {
                JOptionPane.showMessageDialog(component, "Please remove nondeterminism for simulation.\nSelect menu item Test : Highlight Nondeterminism\nto see nondeterministic states.", "Nondeterministic states detected", 0);
                return false;
            }
        } else if (this.automaton instanceof TuringMachine && !Universe.curProfile.transitionsFromTuringFinalStateAllowed()) {
            TuringMachine turingMachine = (TuringMachine)this.automaton;
            State[] stateArray = turingMachine.getFinalStates();
            AutomatonDirectedGraph automatonDirectedGraph = new AutomatonDirectedGraph(turingMachine);
            for (int i = 0; i < stateArray.length; ++i) {
                if (automatonDirectedGraph.fromDegree(stateArray[i], false) <= 0) continue;
                JOptionPane.showMessageDialog(component, "There are transitions from final states.  Please remove them or change \nthe preference in the \"Preferences\" menu in the JFLAP main menu.", "Transitions From Final States", 0);
                return false;
            }
        }
        return true;
    }

    public static boolean isApplicable(Object object) {
        return object instanceof Automaton;
    }

    protected Object getObject() {
        if (this.automaton != null) {
            return this.automaton;
        }
        return this.gram;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    protected void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

