/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import gui.action.AcceptAllFileFilter;
import gui.action.FileNameExtensionFilter;
import gui.editor.EditorPane;
import gui.environment.Universe;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public class SaveGraphUtility {
    public static void saveGraph(Component component, JComponent jComponent, String string, String string2) {
        if (component instanceof EditorPane) {
            component = ((EditorPane)component).getAutomatonPane();
        }
        Image image = component.createImage(component.getWidth(), component.getHeight());
        Graphics graphics = image.getGraphics();
        component.paint(graphics);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, null, null);
        Universe.CHOOSER.resetChoosableFileFilters();
        Universe.CHOOSER.setAcceptAllFileFilterUsed(false);
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(string, string2.split(","));
        Universe.CHOOSER.addChoosableFileFilter(fileNameExtensionFilter);
        Universe.CHOOSER.addChoosableFileFilter(new AcceptAllFileFilter());
        Universe.CHOOSER.setFileFilter(fileNameExtensionFilter);
        int n = Universe.CHOOSER.showSaveDialog(jComponent);
        while (n == 0) {
            int n2;
            File file = Universe.CHOOSER.getSelectedFile();
            if (!new FileNameExtensionFilter(string, string2.split(",")).accept(file)) {
                file = new File(file.getAbsolutePath() + "." + string2.split(",")[0]);
            }
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(Universe.CHOOSER, "File exists. Shall I overwrite?", "FILE OVERWRITE ATTEMPTED", 0)) == 1) {
                n = Universe.CHOOSER.showSaveDialog(jComponent);
                continue;
            }
            try {
                ImageIO.write((RenderedImage)bufferedImage, string2.split(",")[0], file);
                return;
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(jComponent, "Save failed with error:\n" + iOException.getMessage(), "Save failed", 0);
                return;
            }
        }
    }
}

