/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import grammar.Grammar;
import gui.action.SimulateAction;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.Universe;
import gui.sim.TraceWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

public class NoInteractionSimulateAction
extends SimulateAction {
    private Environment environment = null;
    protected static final int WARNING_STEP = 500;

    public NoInteractionSimulateAction(Grammar grammar, Environment environment) {
        super(grammar, environment);
        this.putValue("Name", "Fast Run...");
        this.putValue("AcceleratorKey", null);
        this.environment = environment;
    }

    public NoInteractionSimulateAction(Automaton automaton, Environment environment) {
        super(automaton, environment);
        this.putValue("Name", "Fast Run...");
        this.putValue("AcceleratorKey", null);
        this.environment = environment;
    }

    protected boolean reportConfiguration(Configuration configuration, Component component) {
        JScrollPane jScrollPane = TraceWindow.getPastPane(configuration);
        jScrollPane.setPreferredSize(new Dimension(300, 400));
        Object[] objectArray = new String[]{"Keep looking", "I'm done"};
        int n = JOptionPane.showOptionDialog(component, jScrollPane, "Accepting configuration found!", 0, 1, null, objectArray, null);
        return n == 0;
    }

    protected boolean confirmContinue(int n, Component component) {
        int n2 = JOptionPane.showConfirmDialog(component, n + " configurations have been generated.  " + "Should we continue?");
        return n2 == 0;
    }

    @Override
    public void handleInteraction(Automaton automaton, AutomatonSimulator automatonSimulator, Configuration[] configurationArray, Object object) {
        EnvironmentFrame environmentFrame = Universe.frameForEnvironment(this.environment);
        int n = 0;
        int n2 = 500;
        int n3 = 0;
        while (configurationArray.length > 0) {
            if ((n += configurationArray.length) >= n2) {
                if (!this.confirmContinue(n, environmentFrame)) {
                    return;
                }
                while (n >= n2) {
                    n2 *= 2;
                }
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < configurationArray.length; ++i) {
                if (configurationArray[i].isAccept()) {
                    ++n3;
                    if (this.reportConfiguration(configurationArray[i], environmentFrame)) continue;
                    return;
                }
                arrayList.addAll(automatonSimulator.stepConfiguration(configurationArray[i]));
            }
            configurationArray = arrayList.toArray(new Configuration[0]);
        }
        if (n3 == 0) {
            JOptionPane.showMessageDialog(environmentFrame, "The input was rejected.");
            return;
        }
        JOptionPane.showMessageDialog(environmentFrame, n3 + " configuration" + (n3 == 1 ? "" : "s") + " accepted, and\nother possibilities are exhausted.");
    }
}

