/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.NondeterminismDetector;
import automata.NondeterminismDetectorFactory;
import automata.SimulatorFactory;
import automata.State;
import automata.mealy.MealyConfiguration;
import automata.mealy.MealyMachine;
import automata.turing.TMSimulator;
import automata.turing.TuringMachine;
import grammar.Grammar;
import gui.GrowableTableModel;
import gui.JTableExtender;
import gui.SplitPaneFactory;
import gui.TableTextSizeSlider;
import gui.action.NoInteractionSimulateAction;
import gui.action.TestAction;
import gui.editor.ArrowDisplayOnlyTool;
import gui.editor.EditorPane;
import gui.environment.Environment;
import gui.environment.EnvironmentFrame;
import gui.environment.GrammarEnvironment;
import gui.environment.Profile;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.grammar.GrammarInputPane;
import gui.grammar.parse.BruteParsePane;
import gui.sim.TraceWindow;
import gui.sim.multiple.InputTableModel;
import gui.viewer.AutomatonPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class MultipleSimulateAction
extends NoInteractionSimulateAction {
    protected JTable table = null;
    private static String[] RESULT = new String[]{"Accept", "Reject", "Cancelled"};
    protected JPanel myPanel = null;
    private static Color[] RESULT_COLOR = new Color[]{Color.green, Color.red, Color.black};

    public MultipleSimulateAction(Automaton automaton, Environment environment) {
        super(automaton, environment);
        this.putValue("Name", "Multiple Run");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, MAIN_MENU_MASK));
    }

    public MultipleSimulateAction(Grammar grammar, Environment environment) {
        super(grammar, environment);
        this.putValue("Name", "Multiple Run");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, MAIN_MENU_MASK));
    }

    public String getComponentTitle() {
        return "Multiple Run";
    }

    protected int handleInput(Automaton automaton, AutomatonSimulator automatonSimulator, Configuration[] configurationArray, Object object, List list) {
        EnvironmentFrame environmentFrame = Universe.frameForEnvironment(this.getEnvironment());
        int n = 0;
        int n2 = 500;
        Configuration configuration = configurationArray[configurationArray.length - 1];
        while (configurationArray.length > 0) {
            if ((n += configurationArray.length) >= n2) {
                if (!this.confirmContinue(n, environmentFrame)) {
                    list.add(configuration);
                    return 2;
                }
                while (n >= n2) {
                    n2 *= 2;
                }
            }
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < configurationArray.length; ++i) {
                configuration = configurationArray[i];
                if (configurationArray[i].isAccept()) {
                    list.add(configurationArray[i]);
                    return 0;
                }
                arrayList.addAll(automatonSimulator.stepConfiguration(configurationArray[i]));
            }
            configurationArray = arrayList.toArray(new Configuration[0]);
        }
        list.add(configuration);
        return 1;
    }

    protected JTableExtender initializeTable(Object object) {
        boolean bl = false;
        int n = 0;
        if (this.getEnvironment().myObjects != null) {
            bl = true;
            n = 1;
        }
        InputTableModel inputTableModel = null;
        if (this.getObject() instanceof Automaton) {
            inputTableModel = InputTableModel.getModel((Automaton)this.getObject(), bl);
        } else if (this.getObject() instanceof Grammar) {
            inputTableModel = InputTableModel.getModel((Grammar)this.getObject(), bl);
        }
        JTableExtender jTableExtender = new JTableExtender((TableModel)inputTableModel, this);
        TableColumnModel tableColumnModel = jTableExtender.getColumnModel();
        n += inputTableModel.getInputCount();
        for (int i = inputTableModel.getInputCount(); i > 0; --i) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(n));
        }
        if (bl) {
            ArrayList arrayList = this.getEnvironment().myObjects;
            ArrayList arrayList2 = this.getEnvironment().myTestStrings;
            int n2 = arrayList2.size();
            int n3 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                for (int j = 0; j < arrayList2.size(); ++j) {
                    n3 = j + n2 * i;
                    Object e = arrayList.get(i);
                    if (e instanceof Automaton) {
                        inputTableModel.setValueAt(((Automaton)e).getFileName(), n3, 0);
                        inputTableModel.setValueAt((String)arrayList2.get(j), n3, 1);
                        continue;
                    }
                    if (!(e instanceof Grammar)) continue;
                    inputTableModel.setValueAt(((Grammar)e).getFileName(), n3, 0);
                    inputTableModel.setValueAt((String)arrayList2.get(j), n3, 1);
                }
            }
            while (inputTableModel.getRowCount() - 1 > arrayList.size() * arrayList2.size()) {
                inputTableModel.deleteRow(inputTableModel.getRowCount() - 2);
            }
        }
        jTableExtender.setShowGrid(true);
        jTableExtender.setGridColor(Color.lightGray);
        return jTableExtender;
    }

    public void performAction(Component component) {
        Serializable serializable;
        Object object;
        Object object2;
        if (this.getObject() instanceof Automaton && ((Automaton)this.getObject()).getInitialState() == null) {
            JOptionPane.showMessageDialog(component, "Simulation requires an automaton\nwith an initial state!", "No Initial State", 0);
            return;
        }
        if (this.getObject() instanceof MealyMachine && ((State[])(object2 = ((NondeterminismDetector)(object = NondeterminismDetectorFactory.getDetector((Automaton)(serializable = (Automaton)this.getObject())))).getNondeterministicStates((Automaton)serializable))).length > 0) {
            JOptionPane.showMessageDialog(component, "Please remove nondeterminism for simulation.\nSelect menu item Test : Highlight Nondeterminism\nto see nondeterministic states.", "Nondeterministic states detected", 0);
            return;
        }
        this.table = this.initializeTable(this.getObject());
        if (((InputTableModel)this.table.getModel()).isMultiple) {
            this.getEnvironment().remove(this.getEnvironment().getActive());
        }
        serializable = new JPanel(new BorderLayout());
        object = new JToolBar();
        ((Container)serializable).add(new JScrollPane(this.table), "Center");
        ((Container)serializable).add((Component)object, "South");
        ((Container)serializable).add(new TableTextSizeSlider(this.table), "North");
        ((JToolBar)object).add(new AbstractAction("Load Inputs"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MultipleSimulateAction.this.table.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                InputTableModel inputTableModel = (InputTableModel)MultipleSimulateAction.this.table.getModel();
                JFileChooser jFileChooser = new JFileChooser(System.getProperties().getProperty("user.dir"));
                int n = jFileChooser.showOpenDialog(null);
                File file = null;
                if (n == 0) {
                    file = jFileChooser.getSelectedFile();
                    try {
                        Scanner scanner = new Scanner(file);
                        int n2 = inputTableModel.getRowCount() - 1;
                        while (scanner.hasNext()) {
                            String string = scanner.next();
                            inputTableModel.setValueAt(string, n2, 0);
                            ++n2;
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                }
            }
        });
        ((JToolBar)object).add(new AbstractAction("Run Inputs"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MultipleSimulateAction.this.table.getCellEditor().stopCellEditing();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                InputTableModel inputTableModel = (InputTableModel)MultipleSimulateAction.this.table.getModel();
                if (MultipleSimulateAction.this.getObject() instanceof Automaton) {
                    Automaton automaton = (Automaton)MultipleSimulateAction.this.getObject();
                    AutomatonSimulator automatonSimulator = SimulatorFactory.getSimulator(automaton);
                    String[][] stringArray = inputTableModel.getInputs();
                    int n = stringArray.length;
                    int n2 = 1;
                    if (inputTableModel.isMultiple) {
                        if (automaton instanceof TuringMachine) {
                            n2 = ((TuringMachine)automaton).tapes;
                        }
                        n = MultipleSimulateAction.this.getEnvironment().myTestStrings.size() / n2;
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (i > 0 && i % n == 0) {
                            automaton = (Automaton)MultipleSimulateAction.this.getEnvironment().myObjects.get(i / n);
                            automatonSimulator = SimulatorFactory.getSimulator(automaton);
                        }
                        Configuration[] configurationArray = null;
                        Object object = null;
                        if (automaton instanceof TuringMachine) {
                            configurationArray = ((TMSimulator)automatonSimulator).getInitialConfigurations(stringArray[i]);
                            object = stringArray[i];
                        } else {
                            configurationArray = automatonSimulator.getInitialConfigurations(stringArray[i][0]);
                            object = stringArray[i][0];
                        }
                        ArrayList arrayList = new ArrayList();
                        int n3 = MultipleSimulateAction.this.handleInput(automaton, automatonSimulator, configurationArray, object, arrayList);
                        Configuration configuration = null;
                        if (arrayList.size() != 0) {
                            configuration = (Configuration)arrayList.get(0);
                        }
                        if (MultipleSimulateAction.this.getObject() instanceof MealyMachine) {
                            MealyConfiguration mealyConfiguration = (MealyConfiguration)configuration;
                            inputTableModel.setResult(i, mealyConfiguration.getOutput(), mealyConfiguration, MultipleSimulateAction.this.getEnvironment().myTransducerStrings, i % n * (n2 + 1));
                            continue;
                        }
                        inputTableModel.setResult(i, RESULT[n3], configuration, MultipleSimulateAction.this.getEnvironment().myTransducerStrings, i % n * (n2 + 1));
                    }
                } else if (MultipleSimulateAction.this.getObject() instanceof Grammar) {
                    String[][] stringArray = inputTableModel.getInputs();
                    int n = stringArray.length;
                    Grammar grammar = (Grammar)MultipleSimulateAction.this.getObject();
                    BruteParsePane bruteParsePane = new BruteParsePane((GrammarEnvironment)MultipleSimulateAction.this.getEnvironment(), grammar, inputTableModel);
                    bruteParsePane.inputField.setEditable(false);
                    bruteParsePane.row = -1;
                    bruteParsePane.parseMultiple();
                }
            }
        });
        if (!((InputTableModel)this.table.getModel()).isMultiple) {
            ((JToolBar)object).add(new AbstractAction("Clear"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        MultipleSimulateAction.this.table.getCellEditor().stopCellEditing();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    InputTableModel inputTableModel = (InputTableModel)MultipleSimulateAction.this.table.getModel();
                    inputTableModel.clear();
                }
            });
            object2 = "Lambda";
            if (Universe.curProfile.getEmptyString().equals(Profile.LAMBDA)) {
                object2 = "Lambda";
            } else if (Universe.curProfile.getEmptyString().equals(Profile.EPSILON)) {
                object2 = "Epsilon";
            }
            ((JToolBar)object).add(new AbstractAction("Enter " + (String)object2){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = MultipleSimulateAction.this.table.getSelectedRow();
                    if (n == -1) {
                        return;
                    }
                    for (int i = 0; i < MultipleSimulateAction.this.table.getColumnCount() - 1; ++i) {
                        MultipleSimulateAction.this.table.getModel().setValueAt("", n, i);
                    }
                }
            });
        }
        if (this.getObject() instanceof Automaton) {
            ((JToolBar)object).add(new AbstractAction("View Trace"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int[] nArray = MultipleSimulateAction.this.table.getSelectedRows();
                    InputTableModel inputTableModel = (InputTableModel)MultipleSimulateAction.this.table.getModel();
                    ArrayList<Integer> arrayList = new ArrayList<Integer>();
                    for (int i = 0; i < nArray.length; ++i) {
                        if (nArray[i] == inputTableModel.getRowCount() - 1) continue;
                        Configuration configuration = inputTableModel.getAssociatedConfigurationForRow(nArray[i]);
                        if (configuration == null) {
                            arrayList.add(new Integer(nArray[i] + 1));
                            continue;
                        }
                        TraceWindow traceWindow = new TraceWindow(configuration);
                        traceWindow.setVisible(true);
                        traceWindow.toFront();
                    }
                    if (arrayList.size() > 0) {
                        StringBuffer stringBuffer = new StringBuffer("Row");
                        if (arrayList.size() > 1) {
                            stringBuffer.append("s");
                        }
                        stringBuffer.append(" ");
                        stringBuffer.append(arrayList.get(0));
                        for (int i = 1; i < arrayList.size(); ++i) {
                            if (i == arrayList.size() - 1) {
                                stringBuffer.append(" and ");
                            } else {
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append(arrayList.get(i));
                        }
                        stringBuffer.append("\ndo");
                        if (arrayList.size() == 1) {
                            stringBuffer.append("es");
                        }
                        stringBuffer.append(" not have end configurations.");
                        JOptionPane.showMessageDialog((Component)actionEvent.getSource(), stringBuffer.toString(), "Bad Rows Selected", 0);
                    }
                }
            });
        }
        if (((InputTableModel)this.table.getModel()).isMultiple) {
            ((JToolBar)object).add(new AbstractAction("Edit File"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = MultipleSimulateAction.this.getMachineIndexBySelectedRow(MultipleSimulateAction.this.table);
                    if (n >= 0 && n < MultipleSimulateAction.this.getEnvironment().myObjects.size()) {
                        if (MultipleSimulateAction.this.getObject() instanceof Automaton) {
                            Automaton automaton = (Automaton)MultipleSimulateAction.this.getEnvironment().myObjects.get(n);
                            EditorPane editorPane = new EditorPane(automaton);
                            editorPane.setName(automaton.getFileName());
                            MultipleSimulateAction.this.getEnvironment().add((Component)editorPane, "Edit", new CriticalTag(){});
                            MultipleSimulateAction.this.getEnvironment().setActive(editorPane);
                        } else if (MultipleSimulateAction.this.getObject() instanceof Grammar) {
                            Grammar grammar = (Grammar)MultipleSimulateAction.this.getEnvironment().myObjects.get(n);
                            GrammarInputPane grammarInputPane = new GrammarInputPane(grammar);
                            grammarInputPane.setName(grammar.getFileName());
                            MultipleSimulateAction.this.getEnvironment().add((Component)grammarInputPane, "Edit", new CriticalTag(){});
                            MultipleSimulateAction.this.getEnvironment().setActive(grammarInputPane);
                        }
                    }
                }
            });
            ((JToolBar)object).add(new AbstractAction("Add input string"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    Object object2;
                    boolean bl = true;
                    boolean bl2 = false;
                    if (MultipleSimulateAction.this.getEnvironment().myObjects.get(0) instanceof TuringMachine) {
                        bl2 = true;
                    }
                    if ((object2 = MultipleSimulateAction.this.initialInput(MultipleSimulateAction.this.getEnvironment().getActive(), "Input")) instanceof String) {
                        object = (String[])object2;
                        MultipleSimulateAction.this.getEnvironment().myTestStrings.add(object);
                    } else if (object2 instanceof String[]) {
                        object = (String[])object2;
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            MultipleSimulateAction.this.getEnvironment().myTestStrings.add(object[i]);
                        }
                    } else {
                        return;
                    }
                    if (bl2) {
                        object = MultipleSimulateAction.this.initialInput(MultipleSimulateAction.this.getEnvironment().getActive(), "Expected Output?");
                        if (object instanceof String) {
                            String string = (String)object;
                            MultipleSimulateAction.this.getEnvironment().myTransducerStrings.add(string);
                        } else if (object instanceof String[]) {
                            Object object3 = object;
                            for (int i = 0; i < ((String[])object3).length; ++i) {
                                MultipleSimulateAction.this.getEnvironment().myTransducerStrings.add(object3[i]);
                            }
                        } else {
                            MultipleSimulateAction.this.getEnvironment().myTestStrings.remove(MultipleSimulateAction.this.getEnvironment().myTestStrings.size() - 1);
                            return;
                        }
                    }
                    if ((object = MultipleSimulateAction.this.initialInput(MultipleSimulateAction.this.getEnvironment().getActive(), "Expected Result? (Accept or Reject)")) instanceof String) {
                        String string = (String)object;
                        MultipleSimulateAction.this.getEnvironment().myTransducerStrings.add(string);
                    } else if (object instanceof String[]) {
                        Object object4 = object;
                        MultipleSimulateAction.this.getEnvironment().myTransducerStrings.add(object4[0]);
                    } else {
                        MultipleSimulateAction.this.getEnvironment().myTestStrings.remove(MultipleSimulateAction.this.getEnvironment().myTestStrings.size() - 1);
                        MultipleSimulateAction.this.getEnvironment().myTransducerStrings.remove(MultipleSimulateAction.this.getEnvironment().myTestStrings.size() - 1);
                        return;
                    }
                    MultipleSimulateAction.this.getEnvironment().remove(MultipleSimulateAction.this.getEnvironment().getActive());
                    MultipleSimulateAction.this.performAction(MultipleSimulateAction.this.getEnvironment().getActive());
                }
            });
            ((JToolBar)object).add(new AbstractAction("Add file"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TestAction testAction = new TestAction();
                    testAction.chooseFile(MultipleSimulateAction.this.getEnvironment().getActive(), false);
                    MultipleSimulateAction.this.getEnvironment().remove(MultipleSimulateAction.this.getEnvironment().getActive());
                    MultipleSimulateAction.this.performAction(MultipleSimulateAction.this.getEnvironment().getActive());
                }
            });
            ((JToolBar)object).add(new AbstractAction("Remove file"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = MultipleSimulateAction.this.getMachineIndexBySelectedRow(MultipleSimulateAction.this.table);
                    if (n >= 0 && n < MultipleSimulateAction.this.getEnvironment().myObjects.size()) {
                        MultipleSimulateAction.this.getEnvironment().myObjects.remove(n);
                        int n2 = MultipleSimulateAction.this.table.getSelectedRow();
                        int n3 = MultipleSimulateAction.this.getEnvironment().myObjects.size();
                        int n4 = MultipleSimulateAction.this.getEnvironment().myTestStrings.size();
                        int n5 = n2 % n4;
                        int n6 = n2 - n5;
                        for (int i = 0; i < n4; ++i) {
                            ((InputTableModel)MultipleSimulateAction.this.table.getModel()).deleteRow(n6);
                        }
                        MultipleSimulateAction.this.table.changeSelection(0, 0, false, false);
                    }
                }
            });
            ((JToolBar)object).add(new AbstractAction("Save Results"){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    final JFrame jFrame = new JFrame("Save Location");
                    JRadioButton jRadioButton = new JRadioButton("Save Results with Original File");
                    jRadioButton.setMnemonic(66);
                    jRadioButton.setActionCommand("Save Results with Original File");
                    jRadioButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                        }
                    });
                    final JRadioButton jRadioButton2 = new JRadioButton("Specify New Location");
                    jRadioButton2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                        }
                    });
                    jRadioButton2.setMnemonic(67);
                    jRadioButton2.setActionCommand("Specify New Location");
                    jRadioButton.setSelected(true);
                    ButtonGroup buttonGroup = new ButtonGroup();
                    buttonGroup.add(jRadioButton);
                    buttonGroup.add(jRadioButton2);
                    JPanel jPanel = new JPanel();
                    jPanel.add(jRadioButton);
                    jPanel.add(jRadioButton2);
                    jFrame.getContentPane().add((Component)jPanel, "Center");
                    JButton jButton = new JButton("Accept");
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            int n;
                            Serializable serializable;
                            jFrame.setVisible(false);
                            String string = "";
                            boolean bl = false;
                            if (jRadioButton2.isSelected()) {
                                serializable = null;
                                boolean bl2 = false;
                                while (bl2 || serializable == null) {
                                    if (bl2) continue;
                                    Universe.CHOOSER.setFileFilter(null);
                                    Universe.CHOOSER.setDialogTitle("Choose directory to save files in");
                                    Universe.CHOOSER.setFileSelectionMode(1);
                                    int n2 = Universe.CHOOSER.showSaveDialog(jFrame);
                                    if (n2 != 0) break;
                                    serializable = Universe.CHOOSER.getSelectedFile();
                                    try {
                                        string = ((File)serializable).getCanonicalPath();
                                        n = string.lastIndexOf("\\");
                                        if (n == -1) {
                                            string = string + "/";
                                            continue;
                                        }
                                        string = string + "\\";
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                    }
                                }
                            }
                            if (string.equals("")) {
                                bl = true;
                            }
                            serializable = (InputTableModel)MultipleSimulateAction.this.table.getModel();
                            String string2 = (String)((GrowableTableModel)serializable).getValueAt(0, 0);
                            String string3 = (String)((GrowableTableModel)serializable).getValueAt(0, 0);
                            n = 0;
                            Object e = MultipleSimulateAction.this.getEnvironment().myObjects.get(0);
                            String string4 = string;
                            if (e instanceof Automaton) {
                                if (e instanceof TuringMachine) {
                                    n = 1;
                                }
                                if (bl) {
                                    string4 = ((Automaton)e).getFilePath();
                                }
                            } else if (e instanceof Grammar && bl) {
                                string4 = ((Grammar)e).getFilePath();
                            }
                            try {
                                FileWriter fileWriter = new FileWriter(string4 + "results" + string3 + ".txt");
                                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                                PrintWriter printWriter = new PrintWriter(bufferedWriter);
                                for (int i = 0; i < ((GrowableTableModel)serializable).getRowCount(); ++i) {
                                    int n3;
                                    string3 = (String)((GrowableTableModel)serializable).getValueAt(i, 0);
                                    if (!string3.equals(string2)) {
                                        string2 = string3;
                                        printWriter.flush();
                                        printWriter.close();
                                        if (string3.equals("")) break;
                                        n3 = MultipleSimulateAction.this.getMachineIndexByName(string3);
                                        e = MultipleSimulateAction.this.getEnvironment().myObjects.get(n3);
                                        if (e instanceof Automaton) {
                                            if (!jRadioButton2.isSelected() || bl) {
                                                string4 = ((Automaton)e).getFilePath();
                                            }
                                        } else if (e instanceof Grammar && (!jRadioButton2.isSelected() || bl)) {
                                            string4 = ((Grammar)e).getFilePath();
                                        }
                                        bufferedWriter = new BufferedWriter(new FileWriter(string4 + "results" + string3 + ".txt"));
                                        printWriter = new PrintWriter(bufferedWriter);
                                    }
                                    n3 = 0;
                                    boolean bl3 = false;
                                    boolean bl4 = false;
                                    for (int j = 1; j < ((GrowableTableModel)serializable).getColumnCount(); ++j) {
                                        if (((InputTableModel)serializable).getColumnName(j).startsWith("Input") && n3 == 0) {
                                            printWriter.write("Input: ");
                                            n3 = 1;
                                        }
                                        if (((InputTableModel)serializable).getColumnName(j).startsWith("Output") && !bl4 && n != 0) {
                                            printWriter.write("Output: ");
                                            bl4 = true;
                                        }
                                        if (((InputTableModel)serializable).getColumnName(j).startsWith("Result")) {
                                            bl3 = true;
                                            printWriter.write("Result: ");
                                        }
                                        String string5 = (String)((GrowableTableModel)serializable).getValueAt(i, j);
                                        printWriter.write(string5 + " ");
                                        try {
                                            if (!bl3) continue;
                                            bufferedWriter.newLine();
                                            continue;
                                        }
                                        catch (IOException iOException) {
                                            // empty catch block
                                        }
                                    }
                                }
                                printWriter.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    });
                    jFrame.getContentPane().add((Component)jButton, "South");
                    jFrame.pack();
                    Point point = new Point(100, 50);
                    jFrame.setLocation(point);
                    jFrame.setVisible(true);
                }
            });
        }
        this.myPanel = serializable;
        object2 = this.getObject();
        if (object2 instanceof Automaton) {
            AutomatonPane automatonPane = new AutomatonPane((Automaton)object2);
            automatonPane.addMouseListener(new ArrowDisplayOnlyTool(automatonPane, automatonPane.getDrawer()));
            JSplitPane jSplitPane = SplitPaneFactory.createSplit(this.getEnvironment(), true, 0.5, automatonPane, (Component)serializable);
            MultiplePane multiplePane = new MultiplePane(jSplitPane);
            this.getEnvironment().add((Component)multiplePane, this.getComponentTitle(), new CriticalTag(){});
            this.getEnvironment().setActive(multiplePane);
        } else if (object2 instanceof Grammar) {
            BruteParsePane bruteParsePane = new BruteParsePane((GrammarEnvironment)this.getEnvironment(), (Grammar)object2, (InputTableModel)this.table.getModel());
            bruteParsePane.inputField.setEditable(false);
            if (this.getEnvironment().myTestStrings != null && this.getEnvironment().myTestStrings.size() > 0) {
                bruteParsePane.inputField.setText((String)this.getEnvironment().myTestStrings.get(0));
            }
            JSplitPane jSplitPane = SplitPaneFactory.createSplit(this.getEnvironment(), true, 0.5, bruteParsePane, (Component)serializable);
            MultiplePane multiplePane = new MultiplePane(jSplitPane);
            this.getEnvironment().add((Component)multiplePane, this.getComponentTitle(), new CriticalTag(){});
            this.getEnvironment().setActive(multiplePane);
        }
    }

    private int getMachineIndexBySelectedRow(JTable jTable) {
        InputTableModel inputTableModel = (InputTableModel)jTable.getModel();
        int n = jTable.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        String string = (String)inputTableModel.getValueAt(n, 0);
        return this.getMachineIndexByName(string);
    }

    public int getMachineIndexByName(String string) {
        ArrayList arrayList = this.getEnvironment().myObjects;
        if (arrayList == null) {
            return -1;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Cloneable cloneable;
            Object e = arrayList.get(i);
            if (!(e instanceof Automaton ? ((Automaton)(cloneable = (Automaton)e)).getFileName().equals(string) : e instanceof Grammar && ((Grammar)(cloneable = (Grammar)e)).getFileName().equals(string))) continue;
            return i;
        }
        return -1;
    }

    public void viewAutomaton(JTableExtender jTableExtender) {
        InputTableModel inputTableModel = (InputTableModel)jTableExtender.getModel();
        if (inputTableModel.isMultiple) {
            int n = jTableExtender.getSelectedRow();
            if (n < 0) {
                return;
            }
            String string = (String)inputTableModel.getValueAt(n, 0);
            this.updateView(string, (String)inputTableModel.getValueAt(n, 1), jTableExtender);
        } else if (this.getEnvironment().getObject() instanceof Grammar) {
            this.updateView(((Grammar)this.getEnvironment().getObject()).getFileName(), (String)inputTableModel.getValueAt(jTableExtender.getSelectedRow(), 1), jTableExtender);
        } else if (this.getEnvironment().getObject() instanceof Automaton) {
            this.updateView(((Automaton)this.getEnvironment().getObject()).getFileName(), (String)inputTableModel.getValueAt(jTableExtender.getSelectedRow(), 1), jTableExtender);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.performAction((Component)actionEvent.getSource());
    }

    protected void updateView(String string, String string2, JTableExtender jTableExtender) {
        ArrayList arrayList = this.getEnvironment().myObjects;
        Serializable serializable = null;
        serializable = arrayList != null ? (Serializable)arrayList.get(0) : this.getEnvironment().getObject();
        if (serializable instanceof Automaton && ((InputTableModel)jTableExtender.getModel()).isMultiple) {
            int n = this.getMachineIndexBySelectedRow(jTableExtender);
            Automaton automaton = null;
            automaton = n != -1 ? (Automaton)arrayList.get(n) : (Automaton)this.getEnvironment().getObject();
            AutomatonPane automatonPane = new AutomatonPane(automaton);
            automatonPane.addMouseListener(new ArrowDisplayOnlyTool(automatonPane, automatonPane.getDrawer()));
            JSplitPane jSplitPane = SplitPaneFactory.createSplit(this.getEnvironment(), true, 0.5, automatonPane, this.myPanel);
            MultiplePane multiplePane = new MultiplePane(jSplitPane);
            EnvironmentFrame environmentFrame = Universe.frameForEnvironment(this.getEnvironment());
            String string3 = automaton.getFileName();
            if (string3 != "") {
                environmentFrame.setTitle(string3);
            }
            this.getEnvironment().remove(this.getEnvironment().getActive());
            this.getEnvironment().add((Component)multiplePane, this.getComponentTitle(), new CriticalTag(){});
            this.getEnvironment().setActive(multiplePane);
        } else if (serializable instanceof Grammar && jTableExtender.getSelectedRow() < jTableExtender.getRowCount() - 1) {
            int n = this.getMachineIndexBySelectedRow(jTableExtender);
            Grammar grammar = null;
            grammar = n != -1 ? (Grammar)arrayList.get(n) : (Grammar)this.getEnvironment().getObject();
            BruteParsePane bruteParsePane = new BruteParsePane((GrammarEnvironment)this.getEnvironment(), grammar, null);
            int n2 = 1;
            if (n == -1) {
                n2 = 0;
            }
            bruteParsePane.inputField.setText((String)jTableExtender.getModel().getValueAt(jTableExtender.getSelectedRow(), n2));
            bruteParsePane.inputField.setEditable(false);
            JSplitPane jSplitPane = SplitPaneFactory.createSplit(this.getEnvironment(), true, 0.5, bruteParsePane, this.myPanel);
            MultiplePane multiplePane = new MultiplePane(jSplitPane);
            this.getEnvironment().add((Component)multiplePane, this.getComponentTitle(), new CriticalTag(){});
            EnvironmentFrame environmentFrame = Universe.frameForEnvironment(this.getEnvironment());
            String string4 = grammar.getFileName();
            if (string4 != "") {
                environmentFrame.setTitle(string4);
            }
            this.getEnvironment().remove(this.getEnvironment().getActive());
            this.getEnvironment().add((Component)multiplePane, this.getComponentTitle(), new CriticalTag(){});
            this.getEnvironment().setActive(multiplePane);
        }
    }

    public class MultiplePane
    extends JPanel {
        public JSplitPane mySplit;

        public MultiplePane(JSplitPane jSplitPane) {
            super(new BorderLayout());
            this.mySplit = null;
            this.add((Component)jSplitPane, "Center");
            this.mySplit = jSplitPane;
        }
    }
}

