/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.LambdaCheckerFactory;
import automata.LambdaTransitionChecker;
import automata.Transition;
import gui.action.AutomatonAction;
import gui.editor.ArrowDisplayOnlyTool;
import gui.environment.Environment;
import gui.environment.Universe;
import gui.environment.tag.CriticalTag;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LambdaHighlightAction
extends AutomatonAction {
    private Automaton automaton;
    private Environment environment;

    public LambdaHighlightAction(Automaton automaton, Environment environment) {
        super("Highlight " + Universe.curProfile.getEmptyString() + "-Transitions", null);
        this.automaton = automaton;
        this.environment = environment;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable2;
        Transition[] transitionArray = this.automaton.getTransitions();
        HashSet<Transition> hashSet = new HashSet<Transition>();
        LambdaTransitionChecker lambdaTransitionChecker = LambdaCheckerFactory.getLambdaChecker(this.automaton);
        for (int i = 0; i < transitionArray.length; ++i) {
            if (!lambdaTransitionChecker.isLambdaTransition(transitionArray[i])) continue;
            hashSet.add(transitionArray[i]);
        }
        SelectionDrawer selectionDrawer = new SelectionDrawer(this.automaton);
        for (Serializable serializable2 : hashSet) {
            selectionDrawer.addSelected((Transition)serializable2);
        }
        serializable2 = new LambdaPane(new AutomatonPane(selectionDrawer));
        this.environment.add((Component)serializable2, Universe.curProfile.getEmptyString() + "-Transitions", new CriticalTag(){});
        this.environment.setActive((Component)serializable2);
    }

    private class LambdaPane
    extends JPanel {
        public LambdaPane(AutomatonPane automatonPane) {
            super(new BorderLayout());
            this.add((Component)automatonPane, "Center");
            this.add((Component)new JLabel(Universe.curProfile.getEmptyString() + "-transitions are highlighted."), "North");
            ArrowDisplayOnlyTool arrowDisplayOnlyTool = new ArrowDisplayOnlyTool(automatonPane, automatonPane.getDrawer());
            automatonPane.addMouseListener(arrowDisplayOnlyTool);
        }
    }
}

