/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.pda.PDAToCFGConverter;
import automata.pda.PDATransition;
import automata.pda.PushdownAutomaton;
import gui.action.ConvertAutomatonToGrammarAction;
import gui.environment.AutomatonEnvironment;
import gui.environment.EnvironmentFrame;
import gui.environment.Universe;
import gui.grammar.automata.ConvertController;
import gui.grammar.automata.ConvertPane;
import gui.grammar.automata.PDAConvertController;
import gui.viewer.SelectionDrawer;
import gui.viewer.ZoomPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class ConvertPDAToGrammarAction
extends ConvertAutomatonToGrammarAction {
    private AutomatonEnvironment environment;
    private PushdownAutomaton automaton;
    private PDAToCFGConverter converter = new PDAToCFGConverter();

    public ConvertPDAToGrammarAction(AutomatonEnvironment automatonEnvironment) {
        super(automatonEnvironment);
    }

    @Override
    protected boolean checkAutomaton() {
        EnvironmentFrame environmentFrame = Universe.frameForEnvironment(this.getEnvironment());
        JPanel jPanel = new JPanel(new BorderLayout());
        SelectionDrawer selectionDrawer = new SelectionDrawer(this.getAutomaton());
        JLabel jLabel = new JLabel();
        ZoomPane zoomPane = new ZoomPane(selectionDrawer);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new BevelBorder(1));
        zoomPane.setPreferredSize(new Dimension(300, 200));
        jPanel2.add((Component)zoomPane, "Center");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jLabel, "South");
        State[] stateArray = this.getAutomaton().getFinalStates();
        if (stateArray.length != 1) {
            JOptionPane.showMessageDialog(environmentFrame, "There must be exactly one final state!", "Final State Error", 0);
            return false;
        }
        Transition[] transitionArray = this.getAutomaton().getTransitionsToState(stateArray[0]);
        HashSet<PDATransition> hashSet = new HashSet<PDATransition>();
        for (int i = 0; i < transitionArray.length; ++i) {
            PDATransition pDATransition = (PDATransition)transitionArray[i];
            if (pDATransition.getStringToPop().equals("Z")) continue;
            hashSet.add(pDATransition);
        }
        if (hashSet.size() != 0) {
            selectionDrawer.clearSelected();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                selectionDrawer.addSelected((Transition)iterator.next());
            }
            jLabel.setText("Transitions to final must pop only 'Z'.");
            JOptionPane.showMessageDialog(environmentFrame, jPanel, "Final Transitions Error", 0);
            return false;
        }
        Transition[] transitionArray2 = this.getAutomaton().getTransitions();
        hashSet.clear();
        for (int i = 0; i < transitionArray2.length; ++i) {
            PDATransition pDATransition = (PDATransition)transitionArray2[i];
            if (pDATransition.getStringToPop().length() == 1 && (pDATransition.getStringToPush().length() == 2 || pDATransition.getStringToPush().length() == 0)) continue;
            hashSet.add(pDATransition);
        }
        if (hashSet.size() != 0) {
            selectionDrawer.clearSelected();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                selectionDrawer.addSelected((Transition)iterator.next());
            }
            jLabel.setText("Transitions must pop 1 and push 0 or 2.");
            JOptionPane.showMessageDialog(environmentFrame, jPanel, "Transitions Error", 0);
            return false;
        }
        return true;
    }

    public static boolean isApplicable(Object object) {
        return object instanceof PushdownAutomaton;
    }

    @Override
    protected ConvertController initializeController(ConvertPane convertPane, SelectionDrawer selectionDrawer, Automaton automaton) {
        return new PDAConvertController(convertPane, selectionDrawer, (PushdownAutomaton)automaton);
    }
}

