/*
 * Decompiled with CFR 0.152.
 */
package gui.action;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.turing.TMSimulator;
import automata.turing.TuringMachine;
import gui.action.SimulateAction;
import gui.environment.Environment;
import gui.environment.tag.CriticalTag;
import gui.sim.SimulatorPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class BuildingBlockSimulateAction
extends SimulateAction {
    private Automaton automaton;
    private Environment environment = null;

    public BuildingBlockSimulateAction(Automaton automaton, Environment environment) {
        super(automaton, environment);
        this.putValue("Name", "Step by BuildingBlock");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, MAIN_MENU_MASK));
        this.automaton = automaton;
        this.environment = environment;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.automaton.getInitialState() == null) {
            JOptionPane.showMessageDialog((Component)actionEvent.getSource(), "Simulation requires an automaton\nwith an initial state!", "No Initial State", 0);
            return;
        }
        Object object = this.initialInput((Component)actionEvent.getSource(), "");
        if (object == null) {
            return;
        }
        Configuration[] configurationArray = null;
        AutomatonSimulator automatonSimulator = this.getSimulator(this.automaton);
        if (this.getObject() instanceof TuringMachine) {
            String[] stringArray = (String[])object;
            configurationArray = ((TMSimulator)automatonSimulator).getInitialConfigurations(stringArray);
        } else {
            String string = (String)object;
            configurationArray = automatonSimulator.getInitialConfigurations(string);
        }
        this.handleInteraction(this.automaton, automatonSimulator, configurationArray, object);
    }

    @Override
    public void handleInteraction(Automaton automaton, AutomatonSimulator automatonSimulator, Configuration[] configurationArray, Object list) {
        SimulatorPane simulatorPane = new SimulatorPane(automaton, automatonSimulator, configurationArray, this.environment, true);
        if (list instanceof String[]) {
            list = Arrays.asList((String[])list);
        }
        this.environment.add((Component)simulatorPane, "Simulate: " + list, new CriticalTag(){});
        this.environment.setActive(simulatorPane);
    }

    public static boolean isApplicable(Serializable serializable) {
        return serializable instanceof TuringMachine;
    }
}

