/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class WebFrame
extends JFrame {
    private JEditorPane myBrowserDisplay = new JEditorPane();
    private ArrayList myURLHistory = new ArrayList();
    private int myCurrentPosition = -1;
    private JButton myBackButton;
    private JButton myForwardButton;
    private JButton myStartButton;

    public WebFrame(String string) {
        this.setTitle("Help Browser");
        JPanel jPanel = new JPanel(new BorderLayout());
        Hyperactive hyperactive = new Hyperactive();
        this.myBrowserDisplay.setEditable(false);
        this.myBrowserDisplay.addHyperlinkListener(hyperactive);
        JScrollPane jScrollPane = new JScrollPane(this.myBrowserDisplay);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.getToolBar(), "North");
        String string2 = string;
        if (!string.startsWith("http://")) {
            URL uRL = this.getClass().getResource(string);
            string2 = uRL == null ? "" : uRL.toString();
        }
        this.setContentPane(jPanel);
        this.pack();
        this.setSize(600, 700);
        this.setLocation(50, 50);
        this.setDefaultCloseOperation(1);
        this.goNew(string2);
    }

    public void gotoURL(String string) {
        if (!string.startsWith("http://")) {
            URL uRL = this.getClass().getResource(string);
            string = uRL == null ? "" : uRL.toString();
        }
        this.goNew(string);
    }

    private JToolBar getToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.myBackButton = this.makeButton("Back", "left.gif", new BackAction(), null);
        this.myForwardButton = this.makeButton("Forward", "right.gif", new ForwardAction(), null);
        this.myStartButton = this.makeButton("Main Index", "start.gif", new HomeAction(), null);
        jToolBar.add(this.myBackButton);
        jToolBar.add(this.myForwardButton);
        jToolBar.add(this.myStartButton);
        return jToolBar;
    }

    private JButton makeButton(String string, String string2, ActionListener actionListener, String string3) {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/ICON/web/" + string2));
        JButton jButton = new JButton(string, imageIcon);
        jButton.addActionListener(actionListener);
        jButton.setToolTipText(string3);
        return jButton;
    }

    private void goBack() {
        try {
            --this.myCurrentPosition;
            String string = (String)this.myURLHistory.get(this.myCurrentPosition);
            this.setDisplay(string);
        }
        catch (Throwable throwable) {
            ++this.myCurrentPosition;
        }
    }

    private void goHome() {
        int n = this.myCurrentPosition;
        try {
            this.myCurrentPosition = 0;
            String string = (String)this.myURLHistory.get(this.myCurrentPosition);
            this.setDisplay(string);
        }
        catch (Throwable throwable) {
            this.myCurrentPosition = n;
        }
    }

    private void goForward() {
        try {
            ++this.myCurrentPosition;
            String string = (String)this.myURLHistory.get(this.myCurrentPosition);
            this.setDisplay(string);
        }
        catch (Throwable throwable) {
            --this.myCurrentPosition;
        }
    }

    private void setDisplay(String string) {
        try {
            this.myBrowserDisplay.setPage(string);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            JOptionPane.showMessageDialog(this, "Could not access URL " + string + "!", "Web Error", 0);
            this.myURLHistory.remove(this.myCurrentPosition);
            --this.myCurrentPosition;
        }
        this.setEnabledStates();
    }

    private void setDisplay(URL uRL) {
        try {
            this.myBrowserDisplay.setPage(uRL);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            JOptionPane.showMessageDialog(this, "Could not access URL " + uRL + "!", "Web Error", 0);
            this.myURLHistory.remove(this.myCurrentPosition);
            --this.myCurrentPosition;
        }
        this.setEnabledStates();
    }

    private void goNew(String string) {
        ++this.myCurrentPosition;
        try {
            while (true) {
                String string2 = (String)this.myURLHistory.remove(this.myCurrentPosition);
            }
        }
        catch (Throwable throwable) {
            this.myURLHistory.add(string);
            this.setDisplay(string);
            return;
        }
    }

    private void setEnabledStates() {
        this.myBackButton.setEnabled(this.myCurrentPosition != 0);
        this.myStartButton.setEnabled(this.myCurrentPosition != 0);
        this.myForwardButton.setEnabled(this.myCurrentPosition != this.myURLHistory.size() - 1);
    }

    private class HomeAction
    implements ActionListener {
        private HomeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WebFrame.this.goHome();
        }
    }

    private class ForwardAction
    implements ActionListener {
        private ForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WebFrame.this.goForward();
        }
    }

    private class BackAction
    implements ActionListener {
        private BackAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WebFrame.this.goBack();
        }
    }

    public class Hyperactive
    implements HyperlinkListener {
        @Override
        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                    hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    try {
                        WebFrame.this.goNew(hyperlinkEvent.getURL().toString());
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
    }
}

