/*
 * Decompiled with CFR 0.152.
 */
package gui;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import gui.action.SimulateAction;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputBox
extends JFrame {
    private String myInputString;
    private final Component myComponent;
    private String myTitle;
    private AutomatonSimulator mySimulator;
    private SimulateAction myAction;
    private boolean myIsTuringMachine;
    private Automaton myAutomaton;

    public InputBox(SimulateAction simulateAction, Component component, String string) {
        this.myAction = simulateAction;
        this.myComponent = component;
        this.myTitle = string;
        JPanel jPanel = new JPanel(new GridLayout(3, 2));
        JTextField[] jTextFieldArray = new JTextField[1];
        for (int i = 0; i < 1; ++i) {
            jPanel.add(new JLabel(this.myTitle + " "));
            jTextFieldArray[i] = new JTextField();
            jPanel.add(jTextFieldArray[i]);
        }
        JButton jButton = new JButton("Open Input File");
        jPanel.add(jButton);
        int n = JOptionPane.showOptionDialog(component, jPanel, this.myTitle, 2, 3, null, null, null);
        if (n != 0 && n != 0) {
            return;
        }
        String[] stringArray = new String[1];
        for (int i = 0; i < 1; ++i) {
            stringArray[i] = jTextFieldArray[i].getText();
        }
        System.out.println(stringArray[0]);
    }

    public String getInputString() {
        return this.myInputString;
    }

    public void exit() {
        System.out.println(this.myInputString);
        if (!this.myIsTuringMachine) {
            Configuration[] configurationArray = this.mySimulator.getInitialConfigurations(this.myInputString);
            this.myAction.handleInteraction(this.myAutomaton, this.mySimulator, configurationArray, this.myInputString);
        }
        this.dispose();
    }

    public void addSimulator(Automaton automaton, AutomatonSimulator automatonSimulator, boolean bl) {
        this.myAutomaton = automaton;
        this.mySimulator = automatonSimulator;
        this.myIsTuringMachine = bl;
    }

    public static void main(String[] stringArray) {
        InputBox inputBox = new InputBox(null, null, "input");
    }
}

