/*
 * Decompiled with CFR 0.152.
 */
package grammar;

import grammar.Grammar;
import grammar.Production;
import grammar.ProductionChecker;
import java.util.ArrayList;
import java.util.HashSet;

public class GrammarChecker {
    public static boolean isRegularGrammar(Grammar grammar) {
        return GrammarChecker.isRightLinearGrammar(grammar) || GrammarChecker.isLeftLinearGrammar(grammar);
    }

    public static boolean isRightLinearGrammar(Grammar grammar) {
        ProductionChecker productionChecker = new ProductionChecker();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (ProductionChecker.isRightLinear(productionArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isLeftLinearGrammar(Grammar grammar) {
        ProductionChecker productionChecker = new ProductionChecker();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (ProductionChecker.isLeftLinear(productionArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isContextFreeGrammar(Grammar grammar) {
        ProductionChecker productionChecker = new ProductionChecker();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (ProductionChecker.isRestrictedOnLHS(productionArray[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isVariableInProductions(Grammar grammar, String string) {
        ProductionChecker productionChecker = new ProductionChecker();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (!ProductionChecker.isVariableInProduction(string, productionArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isTerminalInProductions(Grammar grammar, String string) {
        ProductionChecker productionChecker = new ProductionChecker();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (!ProductionChecker.isTerminalInProduction(string, productionArray[i])) continue;
            return true;
        }
        return false;
    }

    public static Production[] getProductionsOnVariable(String string, Grammar grammar) {
        ArrayList<Production> arrayList = new ArrayList<Production>();
        ProductionChecker productionChecker = new ProductionChecker();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (!string.equals(productionArray[i].getLHS())) continue;
            arrayList.add(productionArray[i]);
        }
        return arrayList.toArray(new Production[0]);
    }

    public static Production[] getNonUnitProductionsOnVariable(String string, Grammar grammar) {
        ArrayList<Production> arrayList = new ArrayList<Production>();
        ProductionChecker productionChecker = new ProductionChecker();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (!string.equals(productionArray[i].getLHS()) || ProductionChecker.isUnitProduction(productionArray[i])) continue;
            arrayList.add(productionArray[i]);
        }
        return arrayList.toArray(new Production[0]);
    }

    public static boolean isProductionInGrammar(Production production, Grammar grammar) {
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (!production.equals(productionArray[i])) continue;
            return true;
        }
        return false;
    }

    public static Production[] getProductionsWithVariable(String string, Grammar grammar) {
        ArrayList<Production> arrayList = new ArrayList<Production>();
        ProductionChecker productionChecker = new ProductionChecker();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (!ProductionChecker.isVariableInProduction(string, productionArray[i])) continue;
            arrayList.add(productionArray[i]);
        }
        return arrayList.toArray(new Production[0]);
    }

    public static Production[] getProductionsWithVariableOnRHS(String string, Grammar grammar) {
        ProductionChecker productionChecker = new ProductionChecker();
        ArrayList<Production> arrayList = new ArrayList<Production>();
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            if (!ProductionChecker.isVariableOnRHS(productionArray[i], string)) continue;
            arrayList.add(productionArray[i]);
        }
        return arrayList.toArray(new Production[0]);
    }

    public static String[] getUnresolvedVariables(Grammar grammar) {
        String[] stringArray = grammar.getVariables();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        Production[] productionArray = grammar.getProductions();
        for (int i = 0; i < productionArray.length; ++i) {
            String[] stringArray2 = productionArray[i].getVariablesOnLHS();
            for (int j = 0; j < stringArray2.length; ++j) {
                hashSet.remove(stringArray2[j]);
            }
        }
        return hashSet.toArray(new String[0]);
    }
}

