/*
 * Decompiled with CFR 0.152.
 */
package file.xml;

import file.xml.AbstractTransducer;
import grammar.Grammar;
import grammar.Production;
import grammar.UnboundGrammar;
import java.io.Serializable;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GrammarTransducer
extends AbstractTransducer {
    public static final String PRODUCTION_NAME = "production";
    public static final String PRODUCTION_LEFT_NAME = "left";
    public static final String PRODUCTION_RIGHT_NAME = "right";
    private static final String COMMENT_PRODUCTIONS = "The list of productions.";

    @Override
    public String getType() {
        return "grammar";
    }

    public static Production createProduction(Node node) {
        Map map = GrammarTransducer.elementsToText(node);
        String string = (String)map.get(PRODUCTION_LEFT_NAME);
        String string2 = (String)map.get(PRODUCTION_RIGHT_NAME);
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        return new Production(string, string2);
    }

    public static Element createProductionElement(Document document, Production production) {
        Element element = GrammarTransducer.createElement(document, PRODUCTION_NAME, null, null);
        element.appendChild(GrammarTransducer.createElement(document, PRODUCTION_LEFT_NAME, null, production.getLHS()));
        element.appendChild(GrammarTransducer.createElement(document, PRODUCTION_RIGHT_NAME, null, production.getRHS()));
        return element;
    }

    @Override
    public Serializable fromDOM(Document document) {
        UnboundGrammar unboundGrammar = new UnboundGrammar();
        NodeList nodeList = document.getDocumentElement().getElementsByTagName(PRODUCTION_NAME);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Production production = GrammarTransducer.createProduction(nodeList.item(i));
            unboundGrammar.addProduction(production);
        }
        return unboundGrammar;
    }

    @Override
    public Document toDOM(Serializable serializable) {
        Grammar grammar = (Grammar)serializable;
        Document document = this.newEmptyDocument();
        Element element = document.getDocumentElement();
        Production[] productionArray = grammar.getProductions();
        if (productionArray.length > 0) {
            element.appendChild(GrammarTransducer.createComment(document, COMMENT_PRODUCTIONS));
        }
        for (int i = 0; i < productionArray.length; ++i) {
            element.appendChild(GrammarTransducer.createProductionElement(document, productionArray[i]));
        }
        return document;
    }
}

