/*
 * Decompiled with CFR 0.152.
 */
package file;

import automata.Automaton;
import automata.State;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import automata.pda.PDATransition;
import automata.pda.PushdownAutomaton;
import automata.turing.TMTransition;
import automata.turing.TuringMachine;
import file.Codec;
import file.ParseException;
import grammar.Grammar;
import grammar.Production;
import grammar.UnboundGrammar;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import regular.RegularExpression;

public class JFLAP3Codec
extends Codec {
    public static final String FINITE_AUTOMATON_SUFFIX = ".FA";
    public static final String PUSHDOWN_AUTOMATON_SUFFIX = ".PDA";
    public static final String TURING_MACHINE_SUFFIX = ".TM";
    public static final String TWO_TAPE_TURING_MACHINE_SUFFIX = ".TTM";
    public static final String GRAMMAR_SUFFIX = ".GRM";
    public static final String REGULAR_EXPRESSION_SUFFIX = ".REX";
    private static final String FINITE_AUTOMATON_CODE = "One-Way-FSA";
    private static final String PUSHDOWN_AUTOMATON_CODE = "PDAP";
    private static final String TURING_MACHINE_CODE = "REGTM";

    @Override
    public Serializable decode(File file, Map map) {
        if (file.getName().endsWith(GRAMMAR_SUFFIX)) {
            return this.readGrammar(file);
        }
        if (file.getName().endsWith(REGULAR_EXPRESSION_SUFFIX)) {
            return this.readRE(file);
        }
        return this.readAutomaton(file);
    }

    private RegularExpression readRE(File file) {
        String string = "";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).startsWith("#") || string2.length() == 0) continue;
                string = string2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ParseException("Could not find file " + file.getName() + "!");
        }
        catch (IOException iOException) {
            throw new ParseException("Error accessing file to write!");
        }
        return new RegularExpression(string);
    }

    private Grammar readGrammar(File file) {
        UnboundGrammar unboundGrammar = new UnboundGrammar();
        int n = 0;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                string = string.trim();
                ++n;
                if (string.length() == 0 || string.startsWith("#")) continue;
                String[] stringArray = string.split("\\s+");
                int n2 = stringArray.length;
                if (n2 > 3 || n2 < 2 || !stringArray[1].equals("->")) {
                    throw new ParseException("Line " + n + " is not formatted properly!");
                }
                unboundGrammar.addProduction(new Production(stringArray[0], n2 == 3 ? stringArray[2] : ""));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ParseException("Could not find file " + file.getName() + "!");
        }
        catch (IOException iOException) {
            throw new ParseException("Error accessing file to write!");
        }
        return unboundGrammar;
    }

    private Automaton readAutomaton(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine().trim();
            if (string.equals(FINITE_AUTOMATON_CODE)) {
                return this.readFA(bufferedReader);
            }
            if (string.equals(PUSHDOWN_AUTOMATON_CODE)) {
                return this.readPDA(bufferedReader);
            }
            if (string.equals(TURING_MACHINE_CODE)) {
                return this.readTM(bufferedReader);
            }
            throw new ParseException("Unknown machine type " + string + "!");
        }
        catch (NullPointerException nullPointerException) {
            throw new ParseException("Unexpected end of file!");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ParseException("Could not find file " + file.getName() + "!");
        }
        catch (IOException iOException) {
            throw new ParseException("Error accessing file to write!");
        }
    }

    private FiniteStateAutomaton readFA(BufferedReader bufferedReader) throws IOException {
        FiniteStateAutomaton finiteStateAutomaton = new FiniteStateAutomaton();
        State[] stateArray = this.readStateCreate(finiteStateAutomaton, bufferedReader);
        String[][][] stringArray = this.readTransitionGroups(2, 1, stateArray.length, bufferedReader);
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                String[] stringArray2 = stringArray[i][j];
                State state = stateArray[Integer.parseInt(stringArray2[1]) - 1];
                State state2 = stateArray[i];
                if (stringArray2[0].equals("null")) {
                    stringArray2[0] = "";
                }
                FSATransition fSATransition = new FSATransition(state2, state, stringArray2[0]);
                finiteStateAutomaton.addTransition(fSATransition);
            }
        }
        this.readStateMove(stateArray, bufferedReader);
        return finiteStateAutomaton;
    }

    private PushdownAutomaton readPDA(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine().trim();
        if (!(string.equals("FINAL") || string.equals("EMPTY") || string.equals("FINAL+EMPTY"))) {
            throw new ParseException(string + " is a bad finishing type for PDA!");
        }
        PushdownAutomaton pushdownAutomaton = new PushdownAutomaton();
        State[] stateArray = this.readStateCreate(pushdownAutomaton, bufferedReader);
        String[][][] stringArray = this.readTransitionGroups(5, 3, stateArray.length, bufferedReader);
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                String[] stringArray2 = stringArray[i][j];
                State state = stateArray[Integer.parseInt(stringArray2[3]) - 1];
                State state2 = stateArray[i];
                try {
                    int[] nArray = new int[]{0, 1, 4};
                    for (int k = 0; k < nArray.length; ++k) {
                        if (!stringArray2[nArray[k]].equals("null")) continue;
                        stringArray2[nArray[k]] = "";
                    }
                    PDATransition pDATransition = new PDATransition(state2, state, stringArray2[0], stringArray2[1], stringArray2[4]);
                    pushdownAutomaton.addTransition(pDATransition);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException(illegalArgumentException.getMessage());
                }
            }
        }
        this.readStateMove(stateArray, bufferedReader);
        return pushdownAutomaton;
    }

    private TuringMachine readTM(BufferedReader bufferedReader) throws IOException {
        if (!bufferedReader.readLine().trim().equals("TAPE")) {
            throw new ParseException("Expected TAPE line absent!");
        }
        int n = 0;
        try {
            n = Integer.parseInt(bufferedReader.readLine());
            if (n != 1 && n != 2) {
                throw new ParseException("May only have 1 or 2 tapes!");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Bad format for number of tapes!");
        }
        TuringMachine turingMachine = new TuringMachine(n);
        State[] stateArray = this.readStateCreate(turingMachine, bufferedReader);
        String[][][] stringArray = this.readTransitionGroups(1 + 3 * turingMachine.tapes(), 1, stateArray.length, bufferedReader);
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                String[] stringArray2 = stringArray[i][j];
                State state = stateArray[Integer.parseInt(stringArray2[1]) - 1];
                State state2 = stateArray[i];
                try {
                    int[] nArray;
                    if (turingMachine.tapes() == 1) {
                        int[] nArray2 = new int[2];
                        nArray2[0] = 0;
                        nArray = nArray2;
                        nArray2[1] = 2;
                    } else {
                        int[] nArray3 = new int[4];
                        nArray3[0] = 0;
                        nArray3[1] = 2;
                        nArray3[2] = 4;
                        nArray = nArray3;
                        nArray3[3] = 5;
                    }
                    int[] nArray4 = nArray;
                    for (int k = 0; k < nArray4.length; ++k) {
                        if (!stringArray2[nArray4[k]].equals("B")) continue;
                        stringArray2[nArray4[k]] = "";
                    }
                    TMTransition tMTransition = turingMachine.tapes() == 1 ? new TMTransition(state2, state, stringArray2[0], stringArray2[2], stringArray2[3].toUpperCase()) : new TMTransition(state2, state, new String[]{stringArray2[0], stringArray2[4]}, new String[]{stringArray2[2], stringArray2[5]}, new String[]{stringArray2[3].toUpperCase(), stringArray2[6].toUpperCase()});
                    turingMachine.addTransition(tMTransition);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException(illegalArgumentException.getMessage());
                }
            }
        }
        this.readStateMove(stateArray, bufferedReader);
        return turingMachine;
    }

    private State[] readStateCreate(Automaton automaton, BufferedReader bufferedReader) throws IOException {
        int n;
        State[] stateArray = null;
        try {
            n = Integer.parseInt(bufferedReader.readLine());
            if (n < 0) {
                throw new ParseException("Number of states cannot be " + n + "!");
            }
            stateArray = new State[n];
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Bad format for number of states!");
        }
        for (n = 0; n < stateArray.length; ++n) {
            stateArray[n] = automaton.createState(new Point(0, 0));
        }
        bufferedReader.readLine();
        if (!(automaton instanceof FiniteStateAutomaton)) {
            bufferedReader.readLine();
        }
        try {
            n = Integer.parseInt(bufferedReader.readLine());
            if (n < 1 || n > stateArray.length) {
                throw new ParseException("Initial state cannot be " + n + ".");
            }
            automaton.setInitialState(stateArray[n - 1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Bad format for initial state ID!");
        }
        String string = bufferedReader.readLine();
        String[] stringArray = string.split("\\s+");
        if (stringArray.length == 0) {
            throw new ParseException("Final state list is empty line!");
        }
        try {
            int n2 = Integer.parseInt(stringArray[stringArray.length - 1]);
            if (n2 != 0) {
                throw new ParseException("Final state list not terminated with 0!");
            }
            try {
                for (int i = 0; i < stringArray.length - 1; ++i) {
                    automaton.addFinalState(stateArray[Integer.parseInt(stringArray[i]) - 1]);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ParseException("Bad final state ID read!");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Bad format in final state list!");
        }
        return stateArray;
    }

    private void readStateMove(State[] stateArray, BufferedReader bufferedReader) throws IOException {
        for (int i = 0; i < stateArray.length; ++i) {
            int n;
            int n2;
            String[] stringArray = bufferedReader.readLine().split("\\s+");
            try {
                n2 = Integer.parseInt(stringArray[1]);
                n = Integer.parseInt(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("State " + (i + 1) + "'s position badly formatted.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ParseException("State " + (i + 1) + "'s position string too short.");
            }
            stateArray[i].getPoint().setLocation(n2, n);
        }
    }

    private String[][][] readTransitionGroups(int n, int n2, int n3, BufferedReader bufferedReader) throws IOException {
        String[][][] stringArray = new String[n3][][];
        for (int i = 0; i < n3; ++i) {
            ParseException parseException = new ParseException("Transition line " + (i + 1) + " badly formatted.");
            String[] stringArray2 = bufferedReader.readLine().split("\\s+");
            if (stringArray2.length % n != 1 || !stringArray2[stringArray2.length - 1].equals("EOL")) {
                throw parseException;
            }
            stringArray[i] = new String[stringArray2.length / n][];
            for (int j = 0; j < stringArray[i].length; ++j) {
                int n4;
                stringArray[i][j] = new String[n];
                for (n4 = 0; n4 < n; ++n4) {
                    stringArray[i][j][n4] = stringArray2[n * j + n4];
                }
                try {
                    n4 = Integer.parseInt(stringArray[i][j][n2]);
                    if (n4 >= 1 && n4 <= n3) continue;
                    throw parseException;
                }
                catch (NumberFormatException numberFormatException) {
                    throw parseException;
                }
            }
        }
        return stringArray;
    }

    @Override
    public File encode(Serializable serializable, File file, Map map) {
        return file;
    }

    @Override
    public boolean canEncode(Serializable serializable) {
        return false;
    }

    @Override
    public String getDescription() {
        return "JFLAP 3 File";
    }
}

