/*
 * Decompiled with CFR 0.152.
 */
package automata.pda;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.pda.PDATransition;
import automata.pda.PushdownAutomaton;
import grammar.Production;
import grammar.cfg.ContextFreeGrammar;
import gui.grammar.GrammarTableModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;

public class PDAToCFGConverter {
    protected static final String START_SYMBOL = "S";
    protected int UNIQUE_ID;
    protected HashMap MAP;
    protected static final String LEFT_PAREN = "(";
    protected static final String RIGHT_PAREN = ")";
    protected static final String BOTTOM_OF_STACK = "Z";

    public PDAToCFGConverter() {
        this.initializeConverter();
    }

    public void initializeConverter() {
        this.MAP = new HashMap();
        this.UNIQUE_ID = 0;
    }

    public boolean hasSingleFinalState(Automaton automaton) {
        State[] stateArray = automaton.getFinalStates();
        if (stateArray.length != 1) {
            return false;
        }
        State state = stateArray[0];
        Transition[] transitionArray = automaton.getTransitionsToState(state);
        for (int i = 0; i < transitionArray.length; ++i) {
            PDATransition pDATransition = (PDATransition)transitionArray[i];
            String string = pDATransition.getStringToPop();
            if (string.substring(string.length() - 1).equals(BOTTOM_OF_STACK)) continue;
            return false;
        }
        return true;
    }

    public boolean hasTransitionsInCorrectForm(Automaton automaton) {
        Transition[] transitionArray = automaton.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            if (this.isPushLambdaTransition(transitionArray[i]) || this.isPushTwoTransition(transitionArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isInCorrectFormForConversion(Automaton automaton) {
        return this.hasSingleFinalState(automaton) && this.hasTransitionsInCorrectForm(automaton);
    }

    public boolean isPushTwoTransition(Transition transition) {
        PDATransition pDATransition = (PDATransition)transition;
        String string = pDATransition.getStringToPush();
        if (string.length() != 2) {
            return false;
        }
        String string2 = pDATransition.getStringToPop();
        return string2.length() == 1;
    }

    public boolean isPushLambdaTransition(Transition transition) {
        PDATransition pDATransition = (PDATransition)transition;
        String string = pDATransition.getStringToPush();
        if (string.length() != 0) {
            return false;
        }
        String string2 = pDATransition.getStringToPop();
        return string2.length() == 1;
    }

    private String getUniqueVariable() {
        char[] cArray = new char[]{(char)(65 + this.UNIQUE_ID)};
        ++this.UNIQUE_ID;
        if (65 + this.UNIQUE_ID == 83) {
            ++this.UNIQUE_ID;
        }
        return new String(cArray);
    }

    public boolean isStartSymbol(String string, Automaton automaton) {
        State state = automaton.getInitialState();
        State[] stateArray = automaton.getFinalStates();
        if (stateArray.length > 1) {
            return false;
        }
        State state2 = stateArray[0];
        String string2 = LEFT_PAREN.concat(state.getName().concat(BOTTOM_OF_STACK.concat(state2.getName().concat(RIGHT_PAREN))));
        return string.equals(string2);
    }

    public ArrayList getProductionsForPushTwoTransition(Transition transition, Automaton automaton) {
        ArrayList<Production> arrayList = new ArrayList<Production>();
        String string = transition.getFromState().getName();
        String string2 = transition.getToState().getName();
        PDATransition pDATransition = (PDATransition)transition;
        String string3 = pDATransition.getStringToPop();
        String string4 = pDATransition.getInputToRead();
        String string5 = pDATransition.getStringToPush();
        String string6 = string5.substring(0, 1);
        String string7 = string5.substring(1);
        State[] stateArray = automaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            String string8 = stateArray[i].getName();
            String string9 = LEFT_PAREN.concat(string.concat(string3.concat(string8.concat(RIGHT_PAREN))));
            for (int j = 0; j < stateArray.length; ++j) {
                String string10 = stateArray[j].getName();
                String string11 = LEFT_PAREN.concat(string2.concat(string6.concat(string10.concat(RIGHT_PAREN))));
                String string12 = LEFT_PAREN.concat(string10.concat(string7.concat(string8.concat(RIGHT_PAREN))));
                if (this.MAP.get(string9) == null) {
                    if (this.isStartSymbol(string9, automaton)) {
                        this.MAP.put(string9, START_SYMBOL);
                    } else {
                        this.MAP.put(string9, this.getUniqueVariable());
                    }
                }
                if (this.MAP.get(string11) == null) {
                    if (this.isStartSymbol(string11, automaton)) {
                        this.MAP.put(string11, START_SYMBOL);
                    } else {
                        this.MAP.put(string11, this.getUniqueVariable());
                    }
                }
                if (this.MAP.get(string12) == null) {
                    if (this.isStartSymbol(string12, automaton)) {
                        this.MAP.put(string12, START_SYMBOL);
                    } else {
                        this.MAP.put(string12, this.getUniqueVariable());
                    }
                }
                String string13 = string4.concat(string11.concat(string12));
                Production production = new Production(string9, string13);
                arrayList.add(production);
            }
        }
        return arrayList;
    }

    public ArrayList getProductionsForPushLambdaTransition(Transition transition, Automaton automaton) {
        ArrayList<Production> arrayList = new ArrayList<Production>();
        String string = transition.getFromState().getName();
        String string2 = transition.getToState().getName();
        PDATransition pDATransition = (PDATransition)transition;
        String string3 = pDATransition.getStringToPop();
        String string4 = pDATransition.getInputToRead();
        String string5 = LEFT_PAREN.concat(string.concat(string3.concat(string2.concat(RIGHT_PAREN))));
        if (this.MAP.get(string5) == null) {
            if (this.isStartSymbol(string5, automaton)) {
                this.MAP.put(string5, START_SYMBOL);
            } else {
                this.MAP.put(string5, this.getUniqueVariable());
            }
        }
        String string6 = string4;
        Production production = new Production(string5, string6);
        arrayList.add(production);
        return arrayList;
    }

    public ArrayList createProductionsForTransition(Transition transition, Automaton automaton) {
        ArrayList arrayList = new ArrayList();
        if (this.isPushLambdaTransition(transition)) {
            arrayList.addAll(this.getProductionsForPushLambdaTransition(transition, automaton));
        } else if (this.isPushTwoTransition(transition)) {
            arrayList.addAll(this.getProductionsForPushTwoTransition(transition, automaton));
        }
        return arrayList;
    }

    public Production getSimplifiedProduction(Production production) {
        Object object;
        int n;
        int n2;
        String string = (String)this.MAP.get(production.getLHS());
        String string2 = production.getRHS();
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = string2.indexOf(40)) != -1 && (n = string2.indexOf(41)) != -1) {
            stringBuffer.append(string2.substring(0, n2));
            object = string2.substring(n2, n + 1);
            stringBuffer.append(this.MAP.get(object));
            string2 = string2.substring(n + 1);
        }
        stringBuffer.append(string2);
        object = new Production(string, stringBuffer.toString());
        return object;
    }

    public int numberVariables() {
        return new HashSet(this.MAP.values()).size();
    }

    public ContextFreeGrammar convertToContextFreeGrammar(Automaton automaton) {
        if (!(automaton instanceof PushdownAutomaton)) {
            throw new IllegalArgumentException("automaton must be PushdownAutomaton");
        }
        if (!this.isInCorrectFormForConversion(automaton)) {
            throw new IllegalArgumentException("automaton not in correct form for conversion to CFG");
        }
        this.initializeConverter();
        ArrayList arrayList = new ArrayList();
        ContextFreeGrammar contextFreeGrammar = new ContextFreeGrammar();
        Transition[] transitionArray = automaton.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            arrayList.addAll(this.createProductionsForTransition(transitionArray[i], automaton));
        }
        for (Production production : arrayList) {
            contextFreeGrammar.addProduction(this.getSimplifiedProduction(production));
        }
        return contextFreeGrammar;
    }

    private void purgeProductionsHelper(String string, Production[] productionArray, HashSet hashSet, int[] nArray) {
        for (int i = 0; i < productionArray.length; ++i) {
            int n;
            if (!productionArray[i].getLHS().equals(string) || nArray[i] != 0) continue;
            nArray[i] = 1;
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = new String(productionArray[i].getRHS());
            while (string2.indexOf(LEFT_PAREN) > -1) {
                arrayList.add(string2.substring(string2.indexOf(LEFT_PAREN), string2.indexOf(RIGHT_PAREN) + 1));
                if (string2.indexOf(RIGHT_PAREN) != string2.length() - 1) {
                    string2 = string2.substring(string2.indexOf(RIGHT_PAREN) + 1);
                    continue;
                }
                string2 = "";
            }
            for (n = 0; n < arrayList.size(); ++n) {
                if (nArray[i] != 1 || hashSet.contains(arrayList.get(n))) continue;
                nArray[i] = -1;
            }
            if (nArray[i] != 1) continue;
            nArray[i] = 2;
            for (n = 0; n < arrayList.size(); ++n) {
                this.purgeProductionsHelper((String)arrayList.get(n), productionArray, hashSet, nArray);
            }
        }
    }

    public void purgeProductions(Automaton automaton, GrammarTableModel grammarTableModel) {
        int n;
        Object object;
        boolean bl;
        int n2;
        Production[] productionArray = grammarTableModel.getProductions();
        HashSet<String> hashSet = new HashSet<String>();
        int[] nArray = new int[productionArray.length];
        for (n2 = 0; n2 < productionArray.length; ++n2) {
            nArray[n2] = 0;
        }
        do {
            bl = false;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                Stack<String> stack = new Stack<String>();
                Stack stack2 = new Stack();
                object = productionArray[n2].getRHS();
                while (((String)object).indexOf(LEFT_PAREN) > -1) {
                    stack.push(((String)object).substring(((String)object).indexOf(LEFT_PAREN), ((String)object).indexOf(RIGHT_PAREN) + 1));
                    if (((String)object).indexOf(RIGHT_PAREN) != ((String)object).length() - 1) {
                        object = ((String)object).substring(((String)object).indexOf(RIGHT_PAREN) + 1);
                        continue;
                    }
                    object = "";
                }
                while (stack.size() > 0) {
                    if (!hashSet.contains((String)stack.peek())) {
                        stack2.push(stack.pop());
                        continue;
                    }
                    stack.pop();
                }
                if (stack2.size() != 0 || hashSet.contains(productionArray[n2].getLHS())) continue;
                bl = true;
                hashSet.add(productionArray[n2].getLHS());
            }
        } while (bl);
        String string = LEFT_PAREN + automaton.getInitialState().getName() + BOTTOM_OF_STACK + automaton.getFinalStates()[0].getName() + RIGHT_PAREN;
        this.purgeProductionsHelper(string, productionArray, hashSet, nArray);
        object = new HashMap();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (n = 0; n < 26; ++n) {
            hashSet2.add("" + (char)(65 + n));
        }
        for (n = nArray.length - 1; n >= 0; --n) {
            if (nArray[n] < 2) {
                grammarTableModel.deleteRow(n);
                continue;
            }
            String string2 = productionArray[n].getLHS();
            ((HashMap)object).put(string2, this.MAP.get(string2));
            if (((String)this.MAP.get(string2)).charAt(0) > 'Z') continue;
            hashSet2.remove((String)this.MAP.get(string2));
        }
        this.MAP = object;
        Iterator iterator = hashSet2.iterator();
        for (String string2 : ((HashMap)object).keySet()) {
            if (((String)this.MAP.get(string2)).charAt(0) <= 'Z') continue;
            this.MAP.put(string2, (String)iterator.next());
        }
    }
}

