/*
 * Decompiled with CFR 0.152.
 */
package automata.graph;

import automata.Automaton;
import automata.State;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class DisjointSetsDetector {
    protected ArrayList STATES_IN_A_SET = new ArrayList();

    private void accountForStates(HashSet hashSet) {
        for (State state : hashSet) {
            if (this.STATES_IN_A_SET.contains(state)) continue;
            this.STATES_IN_A_SET.add(state);
        }
    }

    private boolean areDirectlyConnected(State state, State state2, Automaton automaton) {
        if (state == state2) {
            return false;
        }
        return automaton.getTransitionsFromStateToState(state, state2).length != 0 || automaton.getTransitionsFromStateToState(state2, state).length != 0;
    }

    private ArrayList getStatesConnectedToState(State state, Automaton automaton) {
        ArrayList<State> arrayList = new ArrayList<State>();
        State[] stateArray = automaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            if (!this.areDirectlyConnected(state, stateArray[i], automaton)) continue;
            arrayList.add(stateArray[i]);
        }
        return arrayList;
    }

    private void addAllNotInSetToList(ArrayList arrayList, HashSet hashSet, ArrayList arrayList2) {
        for (State state : arrayList) {
            if (hashSet.contains(state)) continue;
            arrayList2.add(state);
        }
    }

    public HashSet getSetIncludingState(State state, Automaton automaton) {
        HashSet<State> hashSet = new HashSet<State>();
        ArrayList<State> arrayList = new ArrayList<State>();
        arrayList.add(state);
        while (!arrayList.isEmpty()) {
            ArrayList arrayList2 = new ArrayList();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                State state2 = (State)iterator.next();
                arrayList2.addAll(this.getStatesConnectedToState(state2, automaton));
                hashSet.add(state2);
                iterator.remove();
            }
            this.addAllNotInSetToList(arrayList2, hashSet, arrayList);
        }
        return hashSet;
    }

    private boolean isAccountedFor(State state) {
        return this.STATES_IN_A_SET.contains(state);
    }

    private boolean accountedForAllStates(Automaton automaton) {
        return this.getUnaccountedForState(automaton) == null;
    }

    public State getUnaccountedForState(Automaton automaton) {
        State[] stateArray = automaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            if (this.isAccountedFor(stateArray[i])) continue;
            return stateArray[i];
        }
        return null;
    }

    public HashSet[] getDisjointSets(Automaton automaton) {
        ArrayList<HashSet> arrayList = new ArrayList<HashSet>();
        this.STATES_IN_A_SET = new ArrayList();
        while (!this.accountedForAllStates(automaton)) {
            State state = this.getUnaccountedForState(automaton);
            HashSet hashSet = this.getSetIncludingState(state, automaton);
            this.accountForStates(hashSet);
            arrayList.add(hashSet);
        }
        return arrayList.toArray(new HashSet[0]);
    }
}

