/*
 * Decompiled with CFR 0.152.
 */
package automata.fsa;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import java.awt.Point;

public class FSALabelHandler {
    private FSALabelHandler() {
    }

    public static boolean hasMultipleCharacterLabels(Automaton automaton) {
        Transition[] transitionArray = automaton.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            FSATransition fSATransition = (FSATransition)transitionArray[i];
            String string = fSATransition.getLabel();
            if (string.length() <= 1) continue;
            return true;
        }
        return false;
    }

    public static void handleLabel(Transition transition, Automaton automaton) {
        State state;
        FSATransition fSATransition = (FSATransition)transition;
        State state2 = state = transition.getFromState();
        State state3 = transition.getToState();
        automaton.removeTransition(fSATransition);
        String string = fSATransition.getLabel();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            State state4 = i == n - 1 ? state3 : automaton.createState(new Point((state2.getPoint().x * (n - i - 1) + state3.getPoint().x * (i + 1)) / n, (state2.getPoint().y * (n - i - 1) + state3.getPoint().y * (i + 1)) / n));
            FSATransition fSATransition2 = new FSATransition(state, state4, string.substring(i, i + 1));
            automaton.addTransition(fSATransition2);
            state = state4;
        }
    }

    public static void splitLabel(Transition transition, Automaton automaton) {
        State state;
        FSATransition fSATransition = (FSATransition)transition;
        State state2 = state = transition.getFromState();
        State state3 = transition.getToState();
        automaton.removeTransition(fSATransition);
        String string = fSATransition.getLabel();
        for (int i = string.charAt(string.indexOf("[") + 1); i <= string.charAt(string.indexOf("[") + 3); ++i) {
            FSATransition fSATransition2 = new FSATransition(state, state3, Character.toString((char)i));
            automaton.addTransition(fSATransition2);
        }
    }

    public static FiniteStateAutomaton removeMultipleCharacterLabels(Automaton automaton) {
        FiniteStateAutomaton finiteStateAutomaton = (FiniteStateAutomaton)automaton.clone();
        Transition[] transitionArray = finiteStateAutomaton.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            FSATransition fSATransition = (FSATransition)transitionArray[i];
            String string = fSATransition.getLabel();
            if (string.length() <= 1) continue;
            FSALabelHandler.handleLabel(fSATransition, finiteStateAutomaton);
        }
        return finiteStateAutomaton;
    }

    public static void removeMultipleCharacterLabelsFromAutomaton(Automaton automaton) {
        Transition[] transitionArray = automaton.getTransitions();
        for (int i = 0; i < transitionArray.length; ++i) {
            FSATransition fSATransition = (FSATransition)transitionArray[i];
            String string = fSATransition.getLabel();
            if (string.length() <= 1) continue;
            FSALabelHandler.handleLabel(fSATransition, automaton);
        }
    }
}

