/*
 * Decompiled with CFR 0.152.
 */
package automata;

import automata.Automaton;
import automata.LambdaCheckerFactory;
import automata.LambdaTransitionChecker;
import automata.State;
import automata.Transition;
import java.util.ArrayList;

public abstract class NondeterminismDetector {
    public abstract boolean areNondeterministic(Transition var1, Transition var2);

    public State[] getNondeterministicStates(Automaton automaton) {
        LambdaTransitionChecker lambdaTransitionChecker = LambdaCheckerFactory.getLambdaChecker(automaton);
        ArrayList<State> arrayList = new ArrayList<State>();
        State[] stateArray = automaton.getStates();
        for (int i = 0; i < stateArray.length; ++i) {
            State state = stateArray[i];
            Transition[] transitionArray = automaton.getTransitionsFromState(state);
            for (int j = 0; j < transitionArray.length; ++j) {
                Transition transition = transitionArray[j];
                if (lambdaTransitionChecker.isLambdaTransition(transition)) {
                    if (arrayList.contains(state)) continue;
                    arrayList.add(state);
                    continue;
                }
                for (int k = j + 1; k < transitionArray.length; ++k) {
                    Transition transition2 = transitionArray[k];
                    if (!this.areNondeterministic(transition, transition2) || arrayList.contains(state)) continue;
                    arrayList.add(state);
                }
            }
        }
        return arrayList.toArray(new State[0]);
    }
}

